/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;

public final class Uuid
implements Sinkable {
    public static final int FIRST_DASH_POS = 8;
    public static final int FOURTH_DASH_POS = 23;
    public static final int SECOND_DASH_POS = 13;
    public static final int THIRD_DASH_POS = 18;
    public static final int UUID_LENGTH = 36;
    private long hi = Long.MIN_VALUE;
    private long lo = Long.MIN_VALUE;

    public Uuid(long lo, long hi) {
        this.of(lo, hi);
    }

    public Uuid() {
    }

    public static void checkDashesAndLength(CharSequence uuid) throws NumericException {
        if (uuid.length() != 36) {
            throw NumericException.INSTANCE;
        }
        if (uuid.charAt(8) != '-' || uuid.charAt(13) != '-' || uuid.charAt(18) != '-' || uuid.charAt(23) != '-') {
            throw NumericException.INSTANCE;
        }
    }

    public static boolean isNull(long lo, long hi) {
        return hi == Long.MIN_VALUE && lo == Long.MIN_VALUE;
    }

    public static long parseHi(CharSequence uuid) throws NumericException {
        long hi1 = Numbers.parseHexLong(uuid, 0, 8);
        long hi2 = Numbers.parseHexLong(uuid, 9, 13);
        long hi3 = Numbers.parseHexLong(uuid, 14, 18);
        return hi1 << 32 | hi2 << 16 | hi3;
    }

    public static long parseLo(CharSequence uuid) throws NumericException {
        long lo1 = Numbers.parseHexLong(uuid, 19, 23);
        long lo2 = Numbers.parseHexLong(uuid, 24, 36);
        return lo1 << 48 | lo2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != Uuid.class) {
            return false;
        }
        Uuid that = (Uuid)o;
        return this.lo == that.lo && this.hi == that.hi;
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public int hashCode() {
        return Hash.hash(this.lo, this.hi);
    }

    public void of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
    }

    public void of(CharSequence uuid) throws NumericException {
        Uuid.checkDashesAndLength(uuid);
        this.lo = Uuid.parseLo(uuid);
        this.hi = Uuid.parseHi(uuid);
    }

    public void ofNull() {
        this.lo = Long.MIN_VALUE;
        this.hi = Long.MIN_VALUE;
    }

    @Override
    public void toSink(CharSink sink) {
        Numbers.appendUuid(this.lo, this.hi, sink);
    }
}

