/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.skin;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinMetadata;

public abstract class SkinFactory {
    private static final Map<ClassLoader, SkinFactory> _FACTORIES = new WeakHashMap<ClassLoader, SkinFactory>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkinFactory getFactory() {
        Map<ClassLoader, SkinFactory> map = _FACTORIES;
        synchronized (map) {
            return _FACTORIES.get(SkinFactory._getClassLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFactory(SkinFactory factory) {
        Map<ClassLoader, SkinFactory> map = _FACTORIES;
        synchronized (map) {
            ClassLoader cl = SkinFactory._getClassLoader();
            if (_FACTORIES.get(cl) != null) {
                throw new IllegalStateException(_LOG.getMessage("FACTORY_ALREADY_AVAILABlE_FOR_THIS_CLASS_LOADER"));
            }
            _FACTORIES.put(cl, factory);
        }
    }

    public Skin createSkin(ExternalContext externalContext, SkinMetadata baseSkinMetadata, SkinMetadata skinMetadata) {
        throw new UnsupportedOperationException(_LOG.getMessage("SKIN_FACTORY_NO_CREATE_SKIN_SUPPORT", this));
    }

    public Skin createSkin(ExternalContext externalContext, SkinMetadata skinMetadata) {
        throw new UnsupportedOperationException(_LOG.getMessage("SKIN_FACTORY_NO_CREATE_SKIN_SUPPORT", this));
    }

    @Deprecated
    public void reload() {
        _LOG.warning("SKIN_FACTORY_NO_RELOAD_SUPPORT", this);
    }

    @Deprecated
    public abstract void addSkin(String var1, Skin var2);

    @Deprecated
    public abstract Skin getSkin(FacesContext var1, String var2);

    @Deprecated
    public abstract Skin getSkin(FacesContext var1, String var2, String var3);

    @Deprecated
    public abstract Skin getSkin(FacesContext var1, String var2, String var3, String var4);

    @Deprecated
    public abstract Iterator<String> getSkinIds();

    private static ClassLoader _getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

