/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidad.share.io.NameResolver;
import org.apache.myfaces.trinidadinternal.share.io.DefaultNameResolver;
import org.apache.myfaces.trinidadinternal.skin.StyleSheetEntry;
import org.apache.myfaces.trinidadinternal.style.StyleContext;

class StyleSheetNameResolver
implements NameResolver {
    private File _localStylesDir;
    private InputStreamProvider _provider;

    public static NameResolver createResolver(StyleContext context, File localStylesDir, InputStreamProvider provider) {
        return new StyleSheetNameResolver(localStylesDir, provider);
    }

    private StyleSheetNameResolver(File localStylesDirectory, InputStreamProvider provider) {
        assert (localStylesDirectory != null);
        assert (provider != null);
        this._localStylesDir = localStylesDirectory;
        this._provider = provider;
    }

    public InputStreamProvider getProvider(String name) throws IOException {
        return this._provider;
    }

    public NameResolver getResolver(String name) {
        URL url = null;
        File file = StyleSheetEntry.resolveLocalFile(this._localStylesDir, name);
        if (file == null && (url = StyleSheetEntry.resolveNonStaticURL(name)) == null) {
            url = StyleSheetEntry.resolveClassLoaderURL(name);
        }
        return new DefaultNameResolver(file, url);
    }
}

