/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.FacesException;
import javax.faces.application.ViewExpiredException;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.myfaces.trinidadinternal.util.serial.DefaultSerialFactory;
import org.apache.myfaces.trinidadinternal.util.serial.SerialFactory;

public final class StateUtils {
    private static final Logger log = Logger.getLogger(StateUtils.class.getName());
    public static final String ZIP_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_ALGORITHM = "DES";
    public static final String DEFAULT_ALGORITHM_PARAMS = "ECB/PKCS5Padding";
    public static final String INIT_PREFIX = "org.apache.myfaces.";
    public static final String USE_ENCRYPTION = "org.apache.myfaces.USE_ENCRYPTION";
    public static final String INIT_SECRET = "org.apache.myfaces.SECRET";
    public static final String INIT_ALGORITHM = "org.apache.myfaces.ALGORITHM";
    public static final String INIT_SECRET_KEY_CACHE = "org.apache.myfaces.SECRET.CACHE";
    public static final String INIT_ALGORITHM_IV = "org.apache.myfaces.ALGORITHM.IV";
    public static final String INIT_ALGORITHM_PARAM = "org.apache.myfaces.ALGORITHM.PARAMETERS";
    public static final String SERIAL_FACTORY = "org.apache.myfaces.trinidad.SERIAL_FACTORY";
    public static final String COMPRESS_STATE_IN_CLIENT = "org.apache.myfaces.COMPRESS_STATE_IN_CLIENT";
    public static final String DEFAULT_MAC_ALGORITHM = "HmacSHA1";
    public static final String INIT_MAC_ALGORITHM = "org.apache.myfaces.MAC_ALGORITHM";
    public static final String INIT_MAC_SECRET = "org.apache.myfaces.MAC_SECRET";
    public static final String INIT_MAC_SECRET_KEY_CACHE = "org.apache.myfaces.MAC_SECRET.CACHE";

    private StateUtils() {
    }

    private static void testConfiguration(ExternalContext ctx) {
        String iv;
        String algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM);
        if (algorithmParams == null) {
            algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM.toLowerCase());
        }
        if ((iv = ctx.getInitParameter(INIT_ALGORITHM_IV)) == null) {
            iv = ctx.getInitParameter(INIT_ALGORITHM_IV.toLowerCase());
        }
        if (algorithmParams != null && algorithmParams.startsWith("CBC") && iv == null) {
            throw new FacesException("org.apache.myfaces.ALGORITHM.PARAMETERS parameter has been set with CBC mode, but no initialization vector has been set  with org.apache.myfaces.ALGORITHM.IV");
        }
    }

    public static boolean enableCompression(ExternalContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        return "true".equals(ctx.getInitParameter(COMPRESS_STATE_IN_CLIENT));
    }

    public static boolean isSecure(ExternalContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        return !"false".equals(ctx.getInitParameter(USE_ENCRYPTION));
    }

    public static final String construct(Object object, ExternalContext ctx) {
        byte[] bytes = StateUtils.getAsByteArray(object, ctx);
        if (StateUtils.enableCompression(ctx)) {
            bytes = StateUtils.compress(bytes);
        }
        if (StateUtils.isSecure(ctx)) {
            bytes = StateUtils.encrypt(bytes, ctx);
        }
        bytes = StateUtils.encode(bytes);
        try {
            return new String(bytes, ZIP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] getAsByteArray(Object object, ExternalContext ctx) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerialFactory serialFactory = (SerialFactory)ctx.getApplicationMap().get(SERIAL_FACTORY);
        if (serialFactory == null) {
            serialFactory = new DefaultSerialFactory();
            ctx.getApplicationMap().put(SERIAL_FACTORY, serialFactory);
        }
        try {
            ObjectOutputStream writer = serialFactory.getObjectOutputStream(outputStream);
            writer.writeObject(object);
            byte[] bytes = outputStream.toByteArray();
            writer.close();
            outputStream.close();
            writer = null;
            outputStream = null;
            return bytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static byte[] encrypt(byte[] insecure, ExternalContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        StateUtils.testConfiguration(ctx);
        SecretKey secretKey = StateUtils.getSecret(ctx);
        String algorithm = StateUtils.findAlgorithm(ctx);
        String algorithmParams = StateUtils.findAlgorithmParams(ctx);
        byte[] iv = StateUtils.findInitializationVector(ctx);
        SecretKey macSecretKey = StateUtils.getMacSecret(ctx);
        String macAlgorithm = StateUtils.findMacAlgorithm(ctx);
        try {
            Mac mac = Mac.getInstance(macAlgorithm);
            mac.init(macSecretKey);
            Cipher cipher = Cipher.getInstance(algorithm + "/" + algorithmParams);
            if (iv != null) {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(1, (Key)secretKey, ivSpec);
            } else {
                cipher.init(1, secretKey);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("encrypting w/ " + algorithm + "/" + algorithmParams);
            }
            int macLenght = mac.getMacLength();
            byte[] secure = new byte[cipher.getOutputSize(insecure.length) + macLenght];
            int secureCount = cipher.doFinal(insecure, 0, insecure.length, secure);
            mac.update(secure, 0, secureCount);
            mac.doFinal(secure, secureCount);
            return secure;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] compress(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            gzip.write(bytes, 0, bytes.length);
            gzip.finish();
            byte[] fewerBytes = baos.toByteArray();
            gzip.close();
            baos.close();
            gzip = null;
            baos = null;
            return fewerBytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static final byte[] encode(byte[] bytes) {
        return new Base64().encode(bytes);
    }

    public static final Object reconstruct(String string, ExternalContext ctx) {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing state : " + string);
            }
            byte[] bytes = string.getBytes(ZIP_CHARSET);
            bytes = StateUtils.decode(bytes);
            if (StateUtils.isSecure(ctx)) {
                bytes = StateUtils.decrypt(bytes, ctx);
            }
            if (StateUtils.enableCompression(ctx)) {
                bytes = StateUtils.decompress(bytes);
            }
            return StateUtils.getAsObject(bytes, ctx);
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "View State cannot be reconstructed", e);
            }
            return null;
        }
    }

    public static final byte[] decode(byte[] bytes) {
        return new Base64().decode(bytes);
    }

    public static final byte[] decompress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("byte[] bytes");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[bytes.length];
        try {
            int length;
            GZIPInputStream gis = new GZIPInputStream(bais);
            while ((length = gis.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            byte[] moreBytes = baos.toByteArray();
            baos.close();
            bais.close();
            gis.close();
            baos = null;
            bais = null;
            gis = null;
            return moreBytes;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static byte[] decrypt(byte[] secure, ExternalContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ExternalContext ctx");
        }
        StateUtils.testConfiguration(ctx);
        SecretKey secretKey = StateUtils.getSecret(ctx);
        String algorithm = StateUtils.findAlgorithm(ctx);
        String algorithmParams = StateUtils.findAlgorithmParams(ctx);
        byte[] iv = StateUtils.findInitializationVector(ctx);
        SecretKey macSecretKey = StateUtils.getMacSecret(ctx);
        String macAlgorithm = StateUtils.findMacAlgorithm(ctx);
        try {
            Mac mac = Mac.getInstance(macAlgorithm);
            mac.init(macSecretKey);
            Cipher cipher = Cipher.getInstance(algorithm + "/" + algorithmParams);
            if (iv != null) {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(2, (Key)secretKey, ivSpec);
            } else {
                cipher.init(2, secretKey);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("decrypting w/ " + algorithm + "/" + algorithmParams);
            }
            int macLenght = mac.getMacLength();
            mac.update(secure, 0, secure.length - macLenght);
            byte[] signedDigestHash = mac.doFinal();
            boolean isMacEqual = true;
            for (int i = 0; i < signedDigestHash.length; ++i) {
                if (signedDigestHash[i] == secure[secure.length - macLenght + i]) continue;
                isMacEqual = false;
            }
            if (!isMacEqual) {
                throw new ViewExpiredException();
            }
            return cipher.doFinal(secure, 0, secure.length - macLenght);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static final Object getAsObject(byte[] bytes, ExternalContext ctx) {
        ByteArrayInputStream input = null;
        try {
            input = new ByteArrayInputStream(bytes);
            SerialFactory serialFactory = (SerialFactory)ctx.getApplicationMap().get(SERIAL_FACTORY);
            if (serialFactory == null) {
                throw new NullPointerException("serialFactory");
            }
            ObjectInputStream s = null;
            Exception pendingException = null;
            try {
                s = serialFactory.getObjectInputStream(input);
                Object object = null;
                if (System.getSecurityManager() != null) {
                    final ObjectInputStream ois = s;
                    object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws PrivilegedActionException, IOException, ClassNotFoundException {
                            return ois.readObject();
                        }
                    });
                } else {
                    object = s.readObject();
                }
                Object object2 = object;
                return object2;
            }
            catch (Exception e) {
                pendingException = e;
                throw new FacesException((Throwable)e);
            }
            finally {
                if (s != null) {
                    try {
                        try {
                            s.close();
                            s = null;
                        }
                        catch (IOException e) {
                            if (pendingException == null) {
                                throw new FacesException((Throwable)e);
                            }
                            s = null;
                        }
                    }
                    catch (Throwable throwable) {
                        s = null;
                        throw throwable;
                    }
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (input != null) {
                try {
                    try {
                        input.close();
                        input = null;
                    }
                    catch (IOException iOException) {
                        input = null;
                    }
                }
                catch (Throwable throwable) {
                    input = null;
                    throw throwable;
                }
            }
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        byte[] bytes = StateUtils.encode(args[0].getBytes(ZIP_CHARSET));
        System.out.println(new String(bytes, ZIP_CHARSET));
    }

    private static byte[] findInitializationVector(ExternalContext ctx) {
        byte[] iv = null;
        String ivString = ctx.getInitParameter(INIT_ALGORITHM_IV);
        if (ivString == null) {
            ivString = ctx.getInitParameter(INIT_ALGORITHM_IV.toLowerCase());
        }
        if (ivString != null) {
            iv = new Base64().decode(ivString.getBytes());
        }
        return iv;
    }

    private static String findAlgorithmParams(ExternalContext ctx) {
        String algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM);
        if (algorithmParams == null) {
            algorithmParams = ctx.getInitParameter(INIT_ALGORITHM_PARAM.toLowerCase());
        }
        if (algorithmParams == null) {
            algorithmParams = DEFAULT_ALGORITHM_PARAMS;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using algorithm paramaters " + algorithmParams);
        }
        return algorithmParams;
    }

    private static String findAlgorithm(ExternalContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_ALGORITHM);
        if (algorithm == null) {
            algorithm = ctx.getInitParameter(INIT_ALGORITHM.toLowerCase());
        }
        return StateUtils.findAlgorithm(algorithm);
    }

    private static String findAlgorithm(ServletContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_ALGORITHM);
        if (algorithm == null) {
            algorithm = ctx.getInitParameter(INIT_ALGORITHM.toLowerCase());
        }
        return StateUtils.findAlgorithm(algorithm);
    }

    private static String findAlgorithm(String initParam) {
        if (initParam == null) {
            initParam = DEFAULT_ALGORITHM;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using algorithm " + initParam);
        }
        return initParam;
    }

    public static void initSecret(ServletContext ctx) {
        String macCache;
        String cache;
        if (ctx == null) {
            throw new NullPointerException("ServletContext ctx");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Storing SecretKey @ org.apache.myfaces.SECRET.CACHE");
        }
        if ((cache = ctx.getInitParameter(INIT_SECRET_KEY_CACHE)) == null) {
            cache = ctx.getInitParameter(INIT_SECRET_KEY_CACHE.toLowerCase());
        }
        if (!"false".equals(cache)) {
            String algorithm = StateUtils.findAlgorithm(ctx);
            ctx.setAttribute(INIT_SECRET_KEY_CACHE, (Object)new SecretKeySpec(StateUtils.findSecret(ctx, algorithm), algorithm));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Storing SecretKey @ org.apache.myfaces.MAC_SECRET.CACHE");
        }
        if ((macCache = ctx.getInitParameter(INIT_MAC_SECRET_KEY_CACHE)) == null) {
            macCache = ctx.getInitParameter(INIT_MAC_SECRET_KEY_CACHE.toLowerCase());
        }
        if (!"false".equals(macCache)) {
            String macAlgorithm = StateUtils.findMacAlgorithm(ctx);
            ctx.setAttribute(INIT_MAC_SECRET_KEY_CACHE, (Object)new SecretKeySpec(StateUtils.findMacSecret(ctx, macAlgorithm), macAlgorithm));
        }
    }

    private static SecretKey getSecret(ExternalContext ctx) {
        SecretKey secretKey = (SecretKey)ctx.getApplicationMap().get(INIT_SECRET_KEY_CACHE);
        if (secretKey == null) {
            String cache = ctx.getInitParameter(INIT_SECRET_KEY_CACHE);
            if (cache == null) {
                cache = ctx.getInitParameter(INIT_SECRET_KEY_CACHE.toLowerCase());
            }
            if ("false".equals(cache)) {
                String secret = ctx.getInitParameter(INIT_SECRET);
                if (secret == null) {
                    secret = ctx.getInitParameter(INIT_SECRET.toLowerCase());
                }
                if (secret == null) {
                    throw new NullPointerException("Could not find secret using key 'org.apache.myfaces.SECRET'");
                }
                String algorithm = StateUtils.findAlgorithm(ctx);
                secretKey = new SecretKeySpec(StateUtils.findSecret(ctx, algorithm), algorithm);
            } else {
                throw new NullPointerException("Could not find SecretKey in application scope using key 'org.apache.myfaces.SECRET.CACHE'");
            }
        }
        if (!(secretKey instanceof SecretKey)) {
            throw new ClassCastException("Did not find an instance of SecretKey in application scope using the key 'org.apache.myfaces.SECRET.CACHE'");
        }
        return secretKey;
    }

    private static byte[] findSecret(ExternalContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_SECRET);
        if (secret == null) {
            secret = ctx.getInitParameter(INIT_SECRET.toLowerCase());
        }
        return StateUtils.findSecret(secret, algorithm);
    }

    private static byte[] findSecret(ServletContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_SECRET);
        if (secret == null) {
            secret = ctx.getInitParameter(INIT_SECRET.toLowerCase());
        }
        return StateUtils.findSecret(secret, algorithm);
    }

    private static byte[] findSecret(String secret, String algorithm) {
        byte[] bytes;
        block5: {
            bytes = null;
            if (secret == null) {
                try {
                    KeyGenerator kg = KeyGenerator.getInstance(algorithm);
                    bytes = kg.generateKey().getEncoded();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("generated random password of length " + bytes.length);
                    }
                    break block5;
                }
                catch (NoSuchAlgorithmException e) {
                    int length = 8;
                    bytes = new byte[length];
                    new Random().nextBytes(bytes);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("generated random password of length " + length);
                    }
                    break block5;
                }
            }
            bytes = new Base64().decode(secret.getBytes());
        }
        return bytes;
    }

    private static String findMacAlgorithm(ExternalContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_MAC_ALGORITHM);
        if (algorithm == null) {
            algorithm = ctx.getInitParameter(INIT_MAC_ALGORITHM.toLowerCase());
        }
        return StateUtils.findMacAlgorithm(algorithm);
    }

    private static String findMacAlgorithm(ServletContext ctx) {
        String algorithm = ctx.getInitParameter(INIT_MAC_ALGORITHM);
        if (algorithm == null) {
            algorithm = ctx.getInitParameter(INIT_MAC_ALGORITHM.toLowerCase());
        }
        return StateUtils.findMacAlgorithm(algorithm);
    }

    private static String findMacAlgorithm(String initParam) {
        if (initParam == null) {
            initParam = DEFAULT_MAC_ALGORITHM;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using algorithm " + initParam);
        }
        return initParam;
    }

    private static SecretKey getMacSecret(ExternalContext ctx) {
        SecretKey secretKey = (SecretKey)ctx.getApplicationMap().get(INIT_MAC_SECRET_KEY_CACHE);
        if (secretKey == null) {
            String cache = ctx.getInitParameter(INIT_MAC_SECRET_KEY_CACHE);
            if (cache == null) {
                cache = ctx.getInitParameter(INIT_MAC_SECRET_KEY_CACHE.toLowerCase());
            }
            if ("false".equals(cache)) {
                String secret = ctx.getInitParameter(INIT_MAC_SECRET);
                if (secret == null) {
                    secret = ctx.getInitParameter(INIT_MAC_SECRET.toLowerCase());
                }
                if (secret == null) {
                    throw new NullPointerException("Could not find secret using key 'org.apache.myfaces.MAC_SECRET'");
                }
                String macAlgorithm = StateUtils.findMacAlgorithm(ctx);
                secretKey = new SecretKeySpec(StateUtils.findMacSecret(ctx, macAlgorithm), macAlgorithm);
            } else {
                throw new NullPointerException("Could not find SecretKey in application scope using key 'org.apache.myfaces.MAC_SECRET.CACHE'");
            }
        }
        if (!(secretKey instanceof SecretKey)) {
            throw new ClassCastException("Did not find an instance of SecretKey in application scope using the key 'org.apache.myfaces.MAC_SECRET.CACHE'");
        }
        return secretKey;
    }

    private static byte[] findMacSecret(ExternalContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_MAC_SECRET);
        if (secret == null) {
            secret = ctx.getInitParameter(INIT_MAC_SECRET.toLowerCase());
        }
        return StateUtils.findMacSecret(secret, algorithm);
    }

    private static byte[] findMacSecret(ServletContext ctx, String algorithm) {
        String secret = ctx.getInitParameter(INIT_MAC_SECRET);
        if (secret == null) {
            secret = ctx.getInitParameter(INIT_MAC_SECRET.toLowerCase());
        }
        return StateUtils.findMacSecret(secret, algorithm);
    }

    private static byte[] findMacSecret(String secret, String algorithm) {
        byte[] bytes;
        block5: {
            bytes = null;
            if (secret == null) {
                try {
                    KeyGenerator kg = KeyGenerator.getInstance(algorithm);
                    bytes = kg.generateKey().getEncoded();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("generated random mac password of length " + bytes.length);
                    }
                    break block5;
                }
                catch (NoSuchAlgorithmException e) {
                    int length = 8;
                    bytes = new byte[length];
                    new Random().nextBytes(bytes);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("generated random mac password of length " + length);
                    }
                    break block5;
                }
            }
            bytes = new Base64().decode(secret.getBytes());
        }
        return bytes;
    }
}

