/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.util.Map;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageRenderer;
import org.apache.myfaces.trinidadinternal.image.laf.browser.MirrorImageFilter;
import org.apache.myfaces.trinidadinternal.image.laf.browser.SourceUtils;
import org.apache.myfaces.trinidadinternal.image.painter.ImageLoader;
import org.apache.myfaces.trinidadinternal.image.painter.ImageUtils;
import org.apache.myfaces.trinidadinternal.style.util.GraphicsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlippedIconImageRenderer
implements ImageRenderer {
    @Override
    public Image renderImage(ImageContext context, Map<Object, Object> requestedProperties, Map<Object, Object> responseProperties) {
        if (!GraphicsUtils.isGraphicalEnvironment()) {
            return null;
        }
        Image icon = SourceUtils.getSourceIcon(context, requestedProperties);
        if (icon == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ImageProducer producer = icon.getSource();
        if (this._isRightToLeft(context)) {
            producer = new FilteredImageSource(producer, new MirrorImageFilter());
        }
        Image flippedIcon = toolkit.createImage(producer);
        ImageUtils.loadImage(flippedIcon);
        ImageLoader loader = new ImageLoader(icon);
        int width = icon.getWidth(loader);
        int height = icon.getHeight(loader);
        if (width != -1) {
            responseProperties.put(ImageConstants.WIDTH_RESPONSE_KEY, width);
        }
        if (height != -1) {
            responseProperties.put(ImageConstants.HEIGHT_RESPONSE_KEY, height);
        }
        BufferedImage bufferedIcon = new BufferedImage(width, height, 6);
        Graphics g = bufferedIcon.getGraphics();
        g.drawImage(flippedIcon, 0, 0, loader);
        flippedIcon.flush();
        return bufferedIcon;
    }

    private boolean _isRightToLeft(ImageContext context) {
        return context.getLocaleContext().isRightToLeft();
    }
}

