/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.List;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.change.AddComponentChange;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class AddChildComponentChange
extends AddComponentChange {
    private final String _insertBeforeId;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AddChildComponentChange.class);
    private static final long serialVersionUID = 1L;

    public AddChildComponentChange(UIComponent childComponent) {
        this(null, childComponent);
    }

    public AddChildComponentChange(String insertBeforeId, UIComponent childComponent) {
        super(childComponent);
        this._insertBeforeId = insertBeforeId;
    }

    public String getInsertBeforeId() {
        return this._insertBeforeId;
    }

    public void changeComponent(UIComponent uiComponent) {
        UIComponent child = this.getComponent();
        if (child == null) {
            return;
        }
        String newChildId = child.getId();
        List children = uiComponent.getChildren();
        UIComponent removableChild = ChangeUtils.getChildForId(uiComponent, newChildId);
        if (removableChild != null) {
            _LOG.info("ATTEMPT_ADD_CHILD_WITH_DUPLICATE_ID", newChildId);
            children.remove(removableChild);
        }
        if (this._insertBeforeId == null) {
            children.add(child);
        } else {
            int index = ChangeUtils.getChildIndexForId(uiComponent, this._insertBeforeId);
            if (index == -1) {
                children.add(child);
            } else {
                children.add(index, child);
            }
        }
    }
}

