/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

public class AccessibilityProfile {
    private final ColorContrast _colorContrast;
    private final FontSize _fontSize;
    private static final AccessibilityProfile _sDefaultInstance = AccessibilityProfile.getInstance(ColorContrast.STANDARD, FontSize.MEDIUM);

    public static AccessibilityProfile getInstance(ColorContrast colorContrast, FontSize fontSize) {
        return new AccessibilityProfile(colorContrast, fontSize);
    }

    public static AccessibilityProfile getDefaultInstance() {
        return _sDefaultInstance;
    }

    public ColorContrast getColorContrast() {
        return this._colorContrast;
    }

    public FontSize getFontSize() {
        return this._fontSize;
    }

    public final boolean isHighContrast() {
        return this._colorContrast == ColorContrast.HIGH;
    }

    public final boolean isLargeFonts() {
        return this._fontSize == FontSize.LARGE;
    }

    private AccessibilityProfile(ColorContrast colorContrast, FontSize fontSize) {
        this._colorContrast = colorContrast == null ? ColorContrast.STANDARD : colorContrast;
        this._fontSize = fontSize == null ? FontSize.MEDIUM : fontSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontSize {
        LARGE,
        MEDIUM;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorContrast {
        HIGH,
        STANDARD;

    }
}

