/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_4.section_4_2_5;

import org.apache.myfaces.portlet.faces.testsuite.common.portlet.GenericFacesTestSuitePortlet;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import java.util.Hashtable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import org.apache.myfaces.portlet.faces.testsuite.common.util.BridgeTCKResultWriter;

/**
 * Non Faces request processing, section 4.2.5.
 * Confirms that for a non Faces request, the response contentType is set, if 
 * not already set, using the preferred contentType expressed by the portlet container.
 */

public class RequestProcessingNonFacesTestPortlet extends GenericFacesTestSuitePortlet
{
  public void render(RenderRequest request, RenderResponse response)
    throws PortletException, IOException
  {
    if ((response.getContentType() == null) 
         && (request.getParameter("_jsfBridgeNonFacesView") != null))
    {
      // Set an attribute to be read by the associated jsp view.  The test
      // is considered to have passed if the response content type is the 
      // same as the request content type.
      request.setAttribute("org.apache.myfaces.portlet.faces.testsuite.4_2_5_nonFacesTest", "1");
    }
    super.render(request, response);
  }
}
