/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.validator.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIFile;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecorationPositionRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.HttpPartWrapper;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.Icons;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.validator.FileItemValidator;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class FileRenderer<T extends AbstractUIFile>
extends DecorationPositionRendererBase<T>
implements ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUIFile)component).isDisabled() || ((AbstractUIFile)component).isReadonly();
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_FILE;
    }

    public void processEvent(ComponentSystemEvent event) {
        TobagoContext.getInstance(FacesContext.getCurrentInstance()).setEnctype("multipart/form-data");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        if (this.isOutputOnly(component)) {
            return;
        }
        boolean multiple = ((AbstractUIFile)component).isMultiple() && !component.isRequired();
        String clientId = component.getClientId(facesContext);
        Object request = facesContext.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            ArrayList<HttpPartWrapper> parts = new ArrayList<HttpPartWrapper>();
            try {
                for (Part part : httpServletRequest.getParts()) {
                    if (!clientId.equals(part.getName())) continue;
                    String fileName = part.getSubmittedFileName();
                    String contentType = part.getContentType();
                    LOG.debug("Uploaded file '{}', size={}, type='{}'.", new Object[]{fileName, part.getSize(), contentType});
                    if (part.getSize() == 0L) {
                        LOG.debug("Ignoring empty file for clientId='{}'.", (Object)clientId);
                    } else if (StringUtils.isBlank(fileName)) {
                        LOG.warn("No fileName provided for clientId='{}'.", (Object)clientId);
                    } else if (StringUtils.isBlank(contentType)) {
                        LOG.warn("No contentType provided for clientId='{}'.", (Object)clientId);
                    } else {
                        parts.add(new HttpPartWrapper(part));
                    }
                    if (multiple || parts.size() <= 0) continue;
                    break;
                }
                if (multiple) {
                    LOG.debug("Adding {} parts {}.", (Object)parts.size(), parts);
                    component.setSubmittedValue((Object)parts.toArray(new Part[0]));
                } else if (parts.size() > 0) {
                    LOG.debug("Adding one part {}.", parts.get(0));
                    component.setSubmittedValue(parts.get(0));
                }
            }
            catch (Exception e) {
                LOG.error("clientId='" + clientId + "'", (Throwable)e);
                component.setValid(false);
            }
        } else {
            LOG.warn("Unsupported request type: " + request.getClass().getName());
        }
        this.decodeClientBehaviors(facesContext, component);
    }

    @Override
    protected void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        Markup markup;
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUIFile)component).getFieldId(facesContext);
        String accept = this.createAcceptFromValidators((AbstractUIFile)component);
        boolean multiple = ((AbstractUIFile)component).isMultiple() && !component.isRequired();
        boolean disabled = ((AbstractUIFile)component).isDisabled();
        boolean readonly = ((AbstractUIFile)component).isReadonly();
        Markup markup2 = markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        if (((AbstractUIFile)component).isMultiple() && component.isRequired()) {
            LOG.warn("Required multiple file upload is not supported.");
        }
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.INPUT_GROUP, component.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.startElement(HtmlElements.INPUT);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.MULTIPLE, multiple);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.FILE);
        writer.writeAttribute(HtmlAttributes.ACCEPT, accept, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, -1);
        writer.writeIdAttribute(fieldId);
        writer.writeClassAttribute(BootstrapClass.FORM_CONTROL, markup.contains(Markup.LARGE) ? BootstrapClass.FORM_CONTROL_LG : null, markup.contains(Markup.SMALL) ? BootstrapClass.FORM_CONTROL_SM : null, BootstrapClass.validationColor(ComponentUtils.getMaximumSeverity(component)));
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled || readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, component.isRequired());
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.endElement(HtmlElements.INPUT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        writer.startElement(HtmlElements.LABEL);
        writer.writeClassAttribute(BootstrapClass.INPUT_GROUP_TEXT);
        writer.writeAttribute(HtmlAttributes.FOR, fieldId, false);
        writer.startElement(HtmlElements.SPAN);
        writer.startElement(HtmlElements.I);
        writer.writeClassAttribute(Icons.FOLDER2_OPEN);
        writer.endElement(HtmlElements.I);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.LABEL);
    }

    private String createAcceptFromValidators(AbstractUIFile file) {
        StringBuilder builder = new StringBuilder();
        for (Validator validator : file.getValidators()) {
            FileItemValidator fileItemValidator;
            String[] contentTypes;
            if (!(validator instanceof FileItemValidator) || (contentTypes = (fileItemValidator = (FileItemValidator)validator).getContentType()) == null) continue;
            for (String contentType : contentTypes) {
                builder.append(",");
                builder.append(contentType);
            }
        }
        if (builder.length() > 0) {
            return builder.substring(1);
        }
        return null;
    }

    private long createMaxSizeFromValidators(AbstractUIFile file) {
        long maxSize = Long.MAX_VALUE;
        for (Validator validator : file.getValidators()) {
            if (!(validator instanceof FileItemValidator)) continue;
            FileItemValidator fileItemValidator = (FileItemValidator)validator;
            maxSize = Long.min(maxSize, fileItemValidator.getMaxSize());
        }
        return maxSize != Long.MAX_VALUE ? maxSize : 0L;
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.startElement(HtmlElements.TOBAGO_PROGRESS);
        writer.writeClassAttribute(BootstrapClass.PROGRESS, BootstrapClass.D_NONE);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.PROGRESS_BAR);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PROGRESSBAR.toString(), false);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.TOBAGO_PROGRESS);
    }

    @Override
    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, T input) throws IOException {
        long maxSize;
        super.writeAdditionalAttributes(facesContext, writer, input);
        String dropZone = ((AbstractUIFile)input).getDropZone();
        if (dropZone != null) {
            String forId = ComponentUtils.evaluateClientId(facesContext, input, dropZone);
            writer.writeAttribute(CustomAttributes.DROP_ZONE, forId, true);
        }
        if ((maxSize = this.createMaxSizeFromValidators((AbstractUIFile)input)) > 0L) {
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.MAX_SIZE, maxSize);
            Locale locale = facesContext.getViewRoot().getLocale();
            MessageFormat maxSizeMessage = new MessageFormat(ResourceUtils.getString(facesContext, "file.maxSizeMessage"), locale);
            writer.writeAttribute(CustomAttributes.MAX_SIZE_MESSAGE, maxSizeMessage.format(new Object[]{maxSize}), true);
        }
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUIFile)component).getFieldId(facesContext);
    }
}

