/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PreRenderComponentEvent;
import javax.swing.BoundedRangeModel;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.SupportFieldId;
import org.apache.myfaces.tobago.component.SupportsLabelLayout;
import org.apache.myfaces.tobago.component.Visual;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public abstract class AbstractUIStars
extends UIInput
implements SupportFieldId,
SupportsLabelLayout,
Visual,
ClientBehaviorHolder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIStars.class);
    private int rangeValue;
    private int rangeMax;

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (event instanceof PreRenderComponentEvent) {
            Object model = this.getValue();
            if (model instanceof BoundedRangeModel) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)model;
                this.rangeValue = boundedRangeModel.getValue();
                this.rangeMax = boundedRangeModel.getMaximum();
            } else {
                this.rangeValue = model instanceof Number ? ((Number)model).intValue() : (model != null && !model.equals("") ? Integer.valueOf("" + model) : 0);
                int n = this.rangeMax = this.getMax() != null ? this.getMax() : 5;
            }
            if (this.rangeMax <= 0) {
                this.rangeMax = 5;
            }
            if (this.rangeValue > this.rangeMax) {
                this.rangeValue = this.rangeMax;
            }
        }
    }

    public abstract boolean isFocus();

    public abstract boolean isReadonly();

    public abstract boolean isDisabled();

    public abstract Integer getMax();

    public abstract Double getPlaceholder();

    public abstract Integer getTabIndex();

    public int getRangeValue() {
        return this.rangeValue;
    }

    public int getRangeMax() {
        return this.rangeMax;
    }

    @Override
    public String getFieldId(FacesContext facesContext) {
        if (this.getLabelLayout() == LabelLayout.skip) {
            return this.getClientId(facesContext);
        }
        return this.getClientId(facesContext) + "::" + "field";
    }

    public boolean isLabelLayoutSkip() {
        return this.getLabelLayout() == LabelLayout.skip;
    }
}

