/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_orchestra.taglib;

import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.webapp.UIComponentTag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_orchestra.el.SimpleActionMethodBinding;

public class UIComponentTagUtils {
    private static final Log log = LogFactory.getLog(UIComponentTagUtils.class);
    private static final Class[] VALIDATOR_ARGS = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final Class[] ACTION_LISTENER_ARGS = new Class[]{ActionEvent.class};
    private static final Class[] VALUE_LISTENER_ARGS = new Class[]{ValueChangeEvent.class};

    private UIComponentTagUtils() {
    }

    public static boolean isValueReference(String v) {
        return UIComponentTag.isValueReference((String)v);
    }

    public static void setIntegerProperty(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Integer.valueOf(value));
            }
        }
    }

    public static void setLongProperty(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Long.valueOf(value));
            }
        }
    }

    public static void setStringProperty(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, value);
            }
        }
    }

    public static void setBooleanProperty(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                component.getAttributes().put(propName, Boolean.valueOf(value));
            }
        }
    }

    public static void setValueProperty(FacesContext context, UIComponent component, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding("value", vb);
            } else if (component instanceof UICommand) {
                ((UICommand)component).setValue((Object)value);
            } else if (component instanceof UIParameter) {
                ((UIParameter)component).setValue((Object)value);
            } else if (component instanceof UISelectBoolean) {
                ((UISelectBoolean)component).setValue((Object)Boolean.valueOf(value));
            } else if (component instanceof UIGraphic) {
                ((UIGraphic)component).setValue((Object)value);
            } else if (component instanceof ValueHolder) {
                ((ValueHolder)component).setValue((Object)value);
            } else {
                log.error((Object)("Component " + component.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void setConverterProperty(FacesContext context, UIComponent component, String value) {
        if (value != null) {
            if (component instanceof ValueHolder) {
                if (UIComponentTagUtils.isValueReference(value)) {
                    ValueBinding vb = context.getApplication().createValueBinding(value);
                    component.setValueBinding("converter", vb);
                } else {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    Converter converter = facesContext.getApplication().createConverter(value);
                    ((ValueHolder)component).setConverter(converter);
                }
            } else {
                log.error((Object)("Component " + component.getClass().getName() + " is no ValueHolder, cannot set value."));
            }
        }
    }

    public static void setValidatorProperty(FacesContext context, UIComponent component, String validator) {
        if (validator != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no EditableValueHolder");
            }
            if (UIComponentTagUtils.isValueReference(validator)) {
                MethodBinding mb = context.getApplication().createMethodBinding(validator, VALIDATOR_ARGS);
                ((EditableValueHolder)component).setValidator(mb);
            } else {
                log.error((Object)("Component " + component.getClientId(context) + " has invalid validation expression " + validator));
            }
        }
    }

    public static void setValueBinding(FacesContext context, UIComponent component, String propName, String value) {
        if (value != null) {
            if (UIComponentTagUtils.isValueReference(value)) {
                ValueBinding vb = context.getApplication().createValueBinding(value);
                component.setValueBinding(propName, vb);
            } else {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " attribute " + propName + " must be a value reference, was " + value);
            }
        }
    }

    public static void setActionProperty(FacesContext context, UIComponent component, String action) {
        if (action != null) {
            if (!(component instanceof ActionSource)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no ActionSource");
            }
            SimpleActionMethodBinding mb = UIComponentTagUtils.isValueReference(action) ? context.getApplication().createMethodBinding(action, null) : new SimpleActionMethodBinding(action);
            ((ActionSource)component).setAction((MethodBinding)mb);
        }
    }

    public static void setActionListenerProperty(FacesContext context, UIComponent component, String actionListener) {
        if (actionListener != null) {
            if (!(component instanceof ActionSource)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no ActionSource");
            }
            if (UIComponentTagUtils.isValueReference(actionListener)) {
                MethodBinding mb = context.getApplication().createMethodBinding(actionListener, ACTION_LISTENER_ARGS);
                ((ActionSource)component).setActionListener(mb);
            } else {
                log.error((Object)("Component " + component.getClientId(context) + " has invalid actionListener value: " + actionListener));
            }
        }
    }

    public static void setValueChangedListenerProperty(FacesContext context, UIComponent component, String valueChangedListener) {
        if (valueChangedListener != null) {
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalArgumentException("Component " + component.getClientId(context) + " is no EditableValueHolder");
            }
            if (UIComponentTagUtils.isValueReference(valueChangedListener)) {
                MethodBinding mb = context.getApplication().createMethodBinding(valueChangedListener, VALUE_LISTENER_ARGS);
                ((EditableValueHolder)component).setValueChangeListener(mb);
            } else {
                log.error((Object)("Component " + component.getClientId(context) + " has invalid valueChangedListener expression " + valueChangedListener));
            }
        }
    }
}

