/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.basic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.ConversationMessager;

/**
 * Handle user-specific notifications about conversation anomalies, when we are running
 * in a plain servlet environment (no JSF etc).
 * <p>
 * Unfortunately there is no standard way of displaying a message to a user in such an
 * environment (except possibly throwing an exception, forcing the standard error page
 * to be shown). This implementation therefore just logs the message to the standard
 * server application log.
 * <p>
 * If you do not like the default behaviour then implement your own version of this
 * class and configure your alternative as the standard "Conversation Messager"
 * instead. See the documentation on interface ConversationMessager for details.
 * <p>
 * As required by the ConversationMessager interface, all methods on this class are thread-safe.
 */
public class LogConversationMessager extends ConversationMessager
{
    private final Log log = LogFactory.getLog(LogConversationMessager.class);

    public void setConversationException(Throwable t)
    {
        log.info("Conversation exception occurred", t);
    }

    public void setConversationNotActive(String name)
    {
        log.info("Conversation not active: " + name);
    }
}
