/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.CoreConfig;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.frameworkAdapter.jsf.JsfFrameworkAdapter;
import org.apache.myfaces.orchestra.lib.jsf.RequestHandler;

class FrameworkAdapterRequestHandler
implements RequestHandler {
    private static final String CONVERSATION_MESSAGER_CLASS = "org.apache.myfaces.orchestra.CONVERSATION_MESSAGER";
    private final Log log = LogFactory.getLog(FrameworkAdapterRequestHandler.class);
    private JsfFrameworkAdapter adapter;

    FrameworkAdapterRequestHandler() {
    }

    public void init(FacesContext facesContext) throws FacesException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"init");
        }
        if (FrameworkAdapter.getCurrentInstance() == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"creating jsfFrameworkAdapter");
            }
            String conversationMessagerClass = FrameworkAdapterRequestHandler.getConversationMessagerClass(facesContext);
            this.adapter = new JsfFrameworkAdapter(conversationMessagerClass);
            this.adapter.beginRequest();
        }
    }

    public void deinit() throws FacesException {
        if (this.adapter != null) {
            this.adapter.endRequest();
        }
    }

    private static String getConversationMessagerClass(FacesContext facesContext) {
        ExternalContext ec = facesContext.getExternalContext();
        String cn = ec.getInitParameter(CONVERSATION_MESSAGER_CLASS);
        if (cn != null) {
            return cn;
        }
        cn = ec.getInitParameter(CoreConfig.CONVERSATION_MESSAGER);
        return cn;
    }
}

