/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.renderkit;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.interceptor.RendererInterceptor;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValLazyRendererProxy;
import org.apache.myfaces.extensions.validator.core.renderkit.ExtValRendererProxy;
import org.apache.myfaces.extensions.validator.core.renderkit.exception.SkipAfterInterceptorsException;
import org.apache.myfaces.extensions.validator.core.renderkit.exception.SkipBeforeInterceptorsException;
import org.apache.myfaces.extensions.validator.core.renderkit.exception.SkipRendererDelegationException;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValRendererWrapper
extends Renderer {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected Renderer wrapped;
    protected ExtValContext extValContext = ExtValContext.getContext();

    public ExtValRendererWrapper(Renderer renderer) {
        Class<? extends ExtValRendererProxy> proxyClass = ExtValCoreConfiguration.get().rendererProxy();
        if (proxyClass == null) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("no extval renderer proxy configured");
            }
            this.wrapped = new ExtValLazyRendererProxy(renderer);
            return;
        }
        Class[] argClasses = new Class[]{Renderer.class};
        try {
            Constructor<? extends ExtValRendererProxy> constructor = proxyClass.getConstructor(argClasses);
            this.wrapped = constructor.newInstance(renderer);
        }
        catch (Throwable t) {
            this.logger.warning("no extval renderer proxy created for " + renderer.getClass().getName());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("extval renderer wrapper created for " + renderer.getClass().getName());
        }
    }

    public final void decode(FacesContext facesContext, UIComponent uiComponent) {
        boolean delegateToWrappedRenderer = true;
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start beforeDecode of " + rendererInterceptor.getClass().getName());
                }
                try {
                    rendererInterceptor.beforeDecode(facesContext, uiComponent, this.wrapped);
                }
                catch (SkipRendererDelegationException e) {
                    this.logger.log(Level.FINEST, "decode delegation canceled", e);
                    delegateToWrappedRenderer = false;
                    if (e.isSkipOtherInterceptors()) break;
                }
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("beforeDecode of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipBeforeInterceptorsException e) {
            this.logger.log(Level.FINEST, "beforeDecode interceptors canceled", e);
        }
        if (delegateToWrappedRenderer) {
            this.wrapped.decode(facesContext, uiComponent);
        }
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start afterDecode of " + rendererInterceptor.getClass().getName());
                }
                rendererInterceptor.afterDecode(facesContext, uiComponent, this.wrapped);
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("afterDecode of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipAfterInterceptorsException e) {
            this.logger.log(Level.FINEST, "afterDecode interceptors canceled", e);
        }
    }

    public final void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean delegateToWrappedRenderer = true;
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start beforeEncodeBegin of " + rendererInterceptor.getClass().getName());
                }
                try {
                    rendererInterceptor.beforeEncodeBegin(facesContext, uiComponent, this.wrapped);
                }
                catch (SkipRendererDelegationException e) {
                    this.logger.log(Level.FINEST, "encodeBegin delegation canceled", e);
                    delegateToWrappedRenderer = false;
                    if (e.isSkipOtherInterceptors()) break;
                }
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("beforeEncodeBegin of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipBeforeInterceptorsException e) {
            this.logger.log(Level.FINEST, "beforeEncodeBegin interceptors canceled", e);
        }
        if (delegateToWrappedRenderer) {
            this.wrapped.encodeBegin(facesContext, uiComponent);
        }
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start afterEncodeBegin of " + rendererInterceptor.getClass().getName());
                }
                rendererInterceptor.afterEncodeBegin(facesContext, uiComponent, this.wrapped);
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("afterEncodeBegin of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipAfterInterceptorsException e) {
            this.logger.log(Level.FINEST, "afterEncodeBegin interceptors canceled", e);
        }
    }

    public final void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean delegateToWrappedRenderer = true;
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start beforeEncodeChildren of " + rendererInterceptor.getClass().getName());
                }
                try {
                    rendererInterceptor.beforeEncodeChildren(facesContext, uiComponent, this.wrapped);
                }
                catch (SkipRendererDelegationException e) {
                    this.logger.log(Level.FINEST, "encodeChildren delegation canceled", e);
                    delegateToWrappedRenderer = false;
                    if (e.isSkipOtherInterceptors()) break;
                }
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("beforeEncodeChildren of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipBeforeInterceptorsException e) {
            this.logger.log(Level.FINEST, "beforeEncodeChildren interceptors canceled", e);
        }
        if (delegateToWrappedRenderer) {
            this.wrapped.encodeChildren(facesContext, uiComponent);
        }
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start afterEncodeChildren of " + rendererInterceptor.getClass().getName());
                }
                rendererInterceptor.afterEncodeChildren(facesContext, uiComponent, this.wrapped);
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("afterEncodeChildren of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipAfterInterceptorsException e) {
            this.logger.log(Level.FINEST, "afterEncodeChildren interceptors canceled", e);
        }
    }

    public final void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        boolean delegateToWrappedRenderer = true;
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start beforeEncodeEnd of " + rendererInterceptor.getClass().getName());
                }
                try {
                    rendererInterceptor.beforeEncodeEnd(facesContext, uiComponent, this.wrapped);
                }
                catch (SkipRendererDelegationException e) {
                    this.logger.log(Level.FINEST, "encodeEnd delegation canceled", e);
                    delegateToWrappedRenderer = false;
                    if (e.isSkipOtherInterceptors()) break;
                }
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("beforeEncodeEnd of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipBeforeInterceptorsException e) {
            this.logger.log(Level.FINEST, "beforeEncodeEnd interceptors canceled", e);
        }
        if (delegateToWrappedRenderer) {
            this.wrapped.encodeEnd(facesContext, uiComponent);
        }
        try {
            for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start afterEncodeEnd of " + rendererInterceptor.getClass().getName());
                }
                rendererInterceptor.afterEncodeEnd(facesContext, uiComponent, this.wrapped);
                if (!this.logger.isLoggable(Level.FINEST)) continue;
                this.logger.finest("afterEncodeEnd of " + rendererInterceptor.getClass().getName() + " finished");
            }
        }
        catch (SkipAfterInterceptorsException e) {
            this.logger.log(Level.FINEST, "afterEncodeEnd interceptors canceled", e);
        }
    }

    public final String convertClientId(FacesContext facesContext, String s) {
        return this.wrapped.convertClientId(facesContext, s);
    }

    public final boolean getRendersChildren() {
        return this.wrapped.getRendersChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object o) throws ConverterException {
        boolean delegateToWrappedRenderer = true;
        Object convertedObject = null;
        try {
            try {
                for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("start beforeGetConvertedValue of " + rendererInterceptor.getClass().getName());
                    }
                    try {
                        rendererInterceptor.beforeGetConvertedValue(facesContext, uiComponent, o, this.wrapped);
                    }
                    catch (SkipRendererDelegationException e) {
                        convertedObject = e.getReturnValueOnException(convertedObject);
                        this.logger.log(Level.FINEST, "getConvertedValue delegation canceled", e);
                        delegateToWrappedRenderer = false;
                        if (e.isSkipOtherInterceptors()) break;
                    }
                    if (!this.logger.isLoggable(Level.FINEST)) continue;
                    this.logger.finest("beforeGetConvertedValue of " + rendererInterceptor.getClass().getName() + " finished");
                }
            }
            catch (SkipBeforeInterceptorsException e) {
                this.logger.log(Level.FINEST, "beforeGetConvertedValue interceptors canceled", e);
            }
            if (delegateToWrappedRenderer) {
                convertedObject = this.wrapped.getConvertedValue(facesContext, uiComponent, o);
            }
            try {
                for (RendererInterceptor rendererInterceptor : this.extValContext.getRendererInterceptors()) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("start afterGetConvertedValue of " + rendererInterceptor.getClass().getName());
                    }
                    rendererInterceptor.afterGetConvertedValue(facesContext, uiComponent, o, this.wrapped);
                    if (!this.logger.isLoggable(Level.FINEST)) continue;
                    this.logger.finest("afterGetConvertedValue of " + rendererInterceptor.getClass().getName() + " finished");
                }
            }
            catch (SkipAfterInterceptorsException e) {
                this.logger.log(Level.FINEST, "afterGetConvertedValue interceptors canceled", e);
            }
        }
        finally {
            if (this.wrapped instanceof ExtValLazyRendererProxy) {
                ((ExtValLazyRendererProxy)this.wrapped).resetConvertedValueCache();
            }
        }
        return convertedObject;
    }
}

