/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.interceptor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.apache.myfaces.extensions.validator.core.interceptor.AbstractRendererInterceptor;
import org.apache.myfaces.extensions.validator.core.renderkit.exception.SkipAfterInterceptorsException;
import org.apache.myfaces.extensions.validator.trinidad.storage.TrinidadClientValidatorStorage;
import org.apache.myfaces.extensions.validator.trinidad.util.TrinidadUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.ReflectionUtils;
import org.apache.myfaces.trinidad.component.core.CoreForm;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputLabel;

public class TrinidadRendererInterceptor
extends AbstractRendererInterceptor {
    public void beforeEncodeBegin(FacesContext facesContext, UIComponent uiComponent, Renderer wrapped) throws IOException {
        if (this.filterCoreOutputLabel(uiComponent)) {
            this.initCoreOutputLabel(facesContext, (CoreOutputLabel)uiComponent);
        }
    }

    public void afterEncodeEnd(FacesContext facesContext, UIComponent uiComponent, Renderer wrapped) throws IOException, SkipAfterInterceptorsException {
        if (uiComponent instanceof CoreForm) {
            this.cleanupExtValClientValidators();
        }
    }

    private void cleanupExtValClientValidators() {
        ((TrinidadClientValidatorStorage)ExtValUtils.getStorage(TrinidadClientValidatorStorage.class, (String)TrinidadClientValidatorStorage.class.getName())).rollback();
    }

    private boolean filterCoreOutputLabel(UIComponent uiComponent) {
        return uiComponent instanceof CoreOutputLabel;
    }

    protected void initCoreOutputLabel(FacesContext facesContext, CoreOutputLabel coreOutputLabel) {
        UIComponent targetComponent = TrinidadUtils.findLabeledEditableComponent(coreOutputLabel);
        if (targetComponent == null || !this.isComponentEditable(targetComponent)) {
            return;
        }
        Map metaDataResult = ExtValUtils.getTransformedMetaData((FacesContext)facesContext, (UIComponent)targetComponent);
        if (!metaDataResult.isEmpty()) {
            ExtValUtils.configureComponentWithMetaData((FacesContext)facesContext, (UIComponent)coreOutputLabel, (Map)metaDataResult);
        }
    }

    private boolean isComponentEditable(UIComponent uiComponent) {
        boolean isReadOnly = !Boolean.FALSE.equals(ReflectionUtils.tryToInvokeMethod((Object)uiComponent, (Method)ReflectionUtils.tryToGetMethod(uiComponent.getClass(), (String)"isReadOnly")));
        boolean isDisabled = !Boolean.FALSE.equals(ReflectionUtils.tryToInvokeMethod((Object)uiComponent, (Method)ReflectionUtils.tryToGetMethod(uiComponent.getClass(), (String)"isDisabled")));
        return !isReadOnly && !isDisabled;
    }
}

