/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.logging;

import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.logging.Logger;
import org.apache.myfaces.extensions.cdi.core.impl.logging.DefaultLoggerFactory;

@Typed
public class DefaultLogger
implements Logger {
    private static final long serialVersionUID = 6112073723716267680L;
    private transient java.util.logging.Logger wrapped;
    private String loggerName = null;
    private String resourceBundleName;
    private boolean anonymous = false;

    protected DefaultLogger() {
        this.anonymous = true;
    }

    protected DefaultLogger(String loggerName) {
        this.loggerName = loggerName;
    }

    protected DefaultLogger(String loggerName, String resourceBundleName, boolean anonymous) {
        this.loggerName = loggerName;
        this.resourceBundleName = resourceBundleName;
        this.anonymous = anonymous;
        if ("".equals(this.loggerName)) {
            this.loggerName = null;
        }
        if ("".equals(this.resourceBundleName)) {
            this.resourceBundleName = null;
        }
    }

    boolean isValid() {
        return this.anonymous || this.loggerName != null || this.resourceBundleName != null;
    }

    public java.util.logging.Logger getWrapped() {
        if (this.wrapped == null) {
            this.lazyInitLogger();
        }
        return this.wrapped;
    }

    public ResourceBundle getResourceBundle() {
        return this.getWrapped().getResourceBundle();
    }

    public String getResourceBundleName() {
        return this.getWrapped().getResourceBundleName();
    }

    public void setFilter(Filter filter) {
        this.getWrapped().setFilter(filter);
    }

    public Filter getFilter() {
        return this.getWrapped().getFilter();
    }

    public void log(LogRecord logRecord) {
        this.getWrapped().log(logRecord);
    }

    public void log(Level level, String s) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.getWrapped().logp(level, this.loggerName, this.getMethodName(), s);
    }

    public void log(Level level, String s, Object o) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.getWrapped().logp(level, this.loggerName, this.getMethodName(), s, o);
    }

    public void log(Level level, String s, Object[] objects) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.getWrapped().logp(level, this.loggerName, this.getMethodName(), s, objects);
    }

    public void log(Level level, String s, Throwable throwable) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.getWrapped().logp(level, this.loggerName, this.getMethodName(), s, throwable);
    }

    public void logp(Level level, String s, String s1, String s2) {
        this.getWrapped().logp(level, s, s1, s2);
    }

    public void logp(Level level, String s, String s1, String s2, Object o) {
        this.getWrapped().logp(level, s, s1, s2, o);
    }

    public void logp(Level level, String s, String s1, String s2, Object[] objects) {
        this.getWrapped().logp(level, s, s1, s2, objects);
    }

    public void logp(Level level, String s, String s1, String s2, Throwable throwable) {
        this.getWrapped().logp(level, s, s1, s2, throwable);
    }

    public void logrb(Level level, String s, String s1, String s2, String s3) {
        this.getWrapped().logrb(level, s, s1, s2, s3);
    }

    public void logrb(Level level, String s, String s1, String s2, String s3, Object o) {
        this.getWrapped().logrb(level, s, s1, s2, s3, o);
    }

    public void logrb(Level level, String s, String s1, String s2, String s3, Object[] objects) {
        this.getWrapped().logrb(level, s, s1, s2, s3, objects);
    }

    public void logrb(Level level, String s, String s1, String s2, String s3, Throwable throwable) {
        this.getWrapped().logrb(level, s, s1, s2, s3, throwable);
    }

    public void entering(String s, String s1) {
        this.getWrapped().entering(s, s1);
    }

    public void entering(String s, String s1, Object o) {
        this.getWrapped().entering(s, s1, o);
    }

    public void entering(String s, String s1, Object[] objects) {
        this.getWrapped().entering(s, s1, objects);
    }

    public void exiting(String s, String s1) {
        this.getWrapped().exiting(s, s1);
    }

    public void exiting(String s, String s1, Object o) {
        this.getWrapped().exiting(s, s1, o);
    }

    public void throwing(String s, String s1, Throwable throwable) {
        this.getWrapped().throwing(s, s1, throwable);
    }

    public void severe(String s) {
        if (!this.isLoggable(Level.SEVERE)) {
            return;
        }
        this.getWrapped().logp(Level.SEVERE, this.loggerName, this.getMethodName(), s);
    }

    public void warning(String s) {
        if (!this.isLoggable(Level.WARNING)) {
            return;
        }
        this.getWrapped().logp(Level.WARNING, this.loggerName, this.getMethodName(), s);
    }

    public void info(String s) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        this.getWrapped().logp(Level.INFO, this.loggerName, this.getMethodName(), s);
    }

    public void config(String s) {
        this.getWrapped().config(s);
    }

    public void fine(String s) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        this.getWrapped().logp(Level.FINE, this.loggerName, this.getMethodName(), s);
    }

    public void finer(String s) {
        if (!this.isLoggable(Level.FINER)) {
            return;
        }
        this.getWrapped().logp(Level.FINER, this.loggerName, this.getMethodName(), s);
    }

    public void finest(String s) {
        if (!this.isLoggable(Level.FINEST)) {
            return;
        }
        this.getWrapped().logp(Level.FINEST, this.loggerName, this.getMethodName(), s);
    }

    public void setLevel(Level level) {
        this.getWrapped().setLevel(level);
    }

    public Level getLevel() {
        return this.getWrapped().getLevel();
    }

    public boolean isLoggable(Level level) {
        return this.getWrapped().isLoggable(level);
    }

    public String getName() {
        return this.getWrapped().getName();
    }

    public void addHandler(Handler handler) {
        this.getWrapped().addHandler(handler);
    }

    public void removeHandler(Handler handler) {
        this.getWrapped().removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this.getWrapped().getHandlers();
    }

    public void setUseParentHandlers(boolean b) {
        this.getWrapped().setUseParentHandlers(b);
    }

    public boolean getUseParentHandlers() {
        return this.getWrapped().getUseParentHandlers();
    }

    public java.util.logging.Logger getParent() {
        return this.getWrapped().getParent();
    }

    public void setParent(java.util.logging.Logger logger) {
        this.getWrapped().setParent(logger);
    }

    public Logger.Factory getFactory() {
        return new DefaultLoggerFactory();
    }

    private void lazyInitLogger() {
        this.wrapped = this.anonymous ? (this.resourceBundleName == null ? java.util.logging.Logger.getAnonymousLogger() : java.util.logging.Logger.getAnonymousLogger(this.resourceBundleName)) : (this.resourceBundleName == null ? java.util.logging.Logger.getLogger(this.loggerName) : java.util.logging.Logger.getLogger(this.loggerName, this.resourceBundleName));
    }

    private String getMethodName() {
        RuntimeException runtimeException = new RuntimeException();
        StackTraceElement[] stackTrace = runtimeException.getStackTrace();
        for (int i = 2; i < stackTrace.length - 1; ++i) {
            if (stackTrace[i].getClassName().equals(this.getClass().getName())) continue;
            return stackTrace[i].getMethodName();
        }
        return "";
    }
}

