/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jpa.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.myfaces.extensions.cdi.core.impl.util.AnyLiteral;
import org.apache.myfaces.extensions.cdi.jpa.api.Transactional;
import org.apache.myfaces.extensions.cdi.jpa.impl.EntityManagerEntry;
import org.apache.myfaces.extensions.cdi.jpa.impl.PersistenceHelper;
import org.apache.myfaces.extensions.cdi.jpa.impl.spi.PersistenceStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Dependent
@Alternative
public class LegacyTransactionalInterceptorStrategy
implements PersistenceStrategy {
    private static final long serialVersionUID = -1432802805095533499L;
    @Inject
    private BeanManager beanManager;
    private static transient ThreadLocal<AtomicInteger> refCount = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(LegacyTransactionalInterceptorStrategy.class.getName());
    private static transient ThreadLocal<HashMap<String, EntityManager>> entityManagerMap = new ThreadLocal();

    public Object execute(InvocationContext context) throws Exception {
        EntityManager entityManager;
        Transactional transactionalAnnotation = this.extractTransactionalAnnotation(context);
        Class<? extends Annotation> qualifierClass = this.getTransactionQualifier(transactionalAnnotation);
        Bean<EntityManager> entityManagerBean = this.resolveEntityManagerBean(qualifierClass);
        EntityManagerEntry entityManagerEntry = null;
        String entityManagerId = qualifierClass.getName();
        if (entityManagerBean == null) {
            entityManagerEntry = PersistenceHelper.tryToFindEntityManagerEntryInTarget(context.getTarget());
            if (entityManagerEntry == null) {
                throw this.unsupportedUsage(context);
            }
            entityManager = entityManagerEntry.getEntityManager();
            entityManagerId = entityManagerEntry.getPersistenceContextEntry().getUnitName();
            if (entityManager == null) {
                return context.proceed();
            }
        } else {
            entityManager = (EntityManager)this.beanManager.getReference(entityManagerBean, EntityManager.class, this.beanManager.createCreationalContext(entityManagerBean));
        }
        if (entityManagerMap.get() == null) {
            entityManagerMap.set(new HashMap());
        }
        entityManagerMap.get().put(entityManagerId, entityManager);
        if (refCount.get() == null) {
            refCount.set(new AtomicInteger(0));
        }
        return this.startProcess(context, entityManagerEntry, entityManager);
    }

    protected Transactional extractTransactionalAnnotation(InvocationContext context) {
        Transactional transactionalAnnotation = context.getMethod().getAnnotation(Transactional.class);
        if (transactionalAnnotation == null) {
            transactionalAnnotation = context.getTarget().getClass().getAnnotation(Transactional.class);
        }
        if (transactionalAnnotation == null) {
            transactionalAnnotation = context.getTarget().getClass().getSuperclass().getAnnotation(Transactional.class);
        }
        return transactionalAnnotation;
    }

    protected Class<? extends Annotation> getTransactionQualifier(Transactional transactionalAnnotation) {
        Class qualifierClass = Default.class;
        if (transactionalAnnotation != null) {
            qualifierClass = transactionalAnnotation.qualifier();
        }
        return qualifierClass;
    }

    protected Bean<EntityManager> resolveEntityManagerBean(Class<? extends Annotation> qualifierClass) {
        HashSet entityManagerBeans = this.beanManager.getBeans(EntityManager.class, new Annotation[]{new AnyLiteral()});
        if (entityManagerBeans == null) {
            entityManagerBeans = new HashSet();
        }
        Bean entityManagerBean = null;
        block0: for (Bean currentEntityManagerBean : entityManagerBeans) {
            Set foundQualifierAnnotations = currentEntityManagerBean.getQualifiers();
            for (Annotation currentQualifierAnnotation : foundQualifierAnnotations) {
                if (!currentQualifierAnnotation.annotationType().equals(qualifierClass)) continue;
                entityManagerBean = currentEntityManagerBean;
                break block0;
            }
        }
        return entityManagerBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object startProcess(InvocationContext context, EntityManagerEntry entityManagerEntry, EntityManager entityManager) throws Exception {
        if (entityManagerEntry != null) {
            EntityManager entityManager2 = entityManager;
            synchronized (entityManager2) {
                return this.proceedMethodInTransaction(context, entityManagerEntry, entityManager);
            }
        }
        return this.proceedMethodInTransaction(context, entityManagerEntry, entityManager);
    }

    protected Object proceedMethodInTransaction(InvocationContext context, EntityManagerEntry entityManagerEntry, EntityManager entityManager) throws Exception {
        Object object;
        block28: {
            Exception firstException = null;
            try {
                this.beginTransaction(entityManager);
                refCount.get().incrementAndGet();
                object = context.proceed();
                Object var10_7 = null;
                if (refCount.get() == null) break block28;
                refCount.get().decrementAndGet();
            }
            catch (Exception e) {
                try {
                    firstException = e;
                    if (refCount.get().intValue() == 1) {
                        for (EntityManager currentEntityManager : entityManagerMap.get().values()) {
                            try {
                                this.rollbackTransaction(currentEntityManager);
                            }
                            catch (Exception eRollback) {
                                LOGGER.log(Level.SEVERE, "Got additional Exception while subsequently rolling back other SQL transactions", eRollback);
                            }
                        }
                        refCount.remove();
                        entityManagerMap.remove();
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    block29: {
                        Object var10_8 = null;
                        if (refCount.get() == null) break block29;
                        refCount.get().decrementAndGet();
                        boolean commitFailed = false;
                        if (refCount.get().intValue() == 0) {
                            if (firstException == null) {
                                for (EntityManager currentEntityManager : entityManagerMap.get().values()) {
                                    try {
                                        currentEntityManager.flush();
                                    }
                                    catch (Exception e2) {
                                        firstException = e2;
                                        commitFailed = true;
                                        break;
                                    }
                                }
                                for (EntityManager currentEntityManager : entityManagerMap.get().values()) {
                                    EntityTransaction transaction = currentEntityManager.getTransaction();
                                    if (transaction == null || !transaction.isActive()) continue;
                                    try {
                                        if (!commitFailed) {
                                            this.commitTransaction(currentEntityManager);
                                            continue;
                                        }
                                        this.rollbackTransaction(currentEntityManager);
                                    }
                                    catch (Exception e3) {
                                        firstException = e3;
                                        commitFailed = true;
                                    }
                                }
                            }
                            refCount.remove();
                            entityManagerMap.remove();
                            if (!commitFailed) {
                                this.endProcess(entityManagerEntry, entityManager, null);
                            } else {
                                this.endProcess(entityManagerEntry, entityManager, firstException);
                            }
                        }
                    }
                    throw throwable;
                }
            }
            boolean commitFailed = false;
            if (refCount.get().intValue() == 0) {
                if (firstException == null) {
                    for (EntityManager currentEntityManager : entityManagerMap.get().values()) {
                        try {
                            currentEntityManager.flush();
                        }
                        catch (Exception e2) {
                            firstException = e2;
                            commitFailed = true;
                            break;
                        }
                    }
                    for (EntityManager currentEntityManager : entityManagerMap.get().values()) {
                        EntityTransaction transaction = currentEntityManager.getTransaction();
                        if (transaction == null || !transaction.isActive()) continue;
                        try {
                            if (!commitFailed) {
                                this.commitTransaction(currentEntityManager);
                                continue;
                            }
                            this.rollbackTransaction(currentEntityManager);
                        }
                        catch (Exception e3) {
                            firstException = e3;
                            commitFailed = true;
                        }
                    }
                }
                refCount.remove();
                entityManagerMap.remove();
                if (!commitFailed) {
                    this.endProcess(entityManagerEntry, entityManager, null);
                } else {
                    this.endProcess(entityManagerEntry, entityManager, firstException);
                }
            }
        }
        return object;
    }

    protected void beginTransaction(EntityManager entityManager) {
        EntityTransaction transaction = entityManager.getTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
        }
    }

    protected void commitTransaction(EntityManager entityManager) {
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.commit();
    }

    protected void rollbackTransaction(EntityManager entityManager) {
        EntityTransaction transaction = entityManager.getTransaction();
        if (transaction != null && transaction.isActive()) {
            transaction.rollback();
        }
    }

    protected void endProcess(EntityManagerEntry entityManagerEntry, EntityManager entityManager, Exception exception) throws Exception {
        if (exception != null) {
            throw exception;
        }
        if (entityManagerEntry != null && entityManager != null && entityManager.isOpen() && !entityManagerEntry.getPersistenceContextEntry().isExtended()) {
            entityManager.clear();
        }
    }

    private IllegalStateException unsupportedUsage(InvocationContext context) {
        String target = context.getTarget().getClass().getName();
        if (context.getMethod().isAnnotationPresent(Transactional.class)) {
            target = target + "." + context.getMethod().getName();
        }
        return new IllegalStateException("Please check your implementation! There is no @Transactional or @Transactional(MyQualifier.class) or @PersistenceContext at " + target + " Please check the documentation for the correct usage or contact the mailing list. " + "Hint: @Transactional just allows one qualifier -> using multiple Entity-Managers " + "(-> different qualifiers) within ONE intercepted method isn't supported.");
    }
}

