/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import jakarta.el.CompositeELResolver;
import jakarta.el.ELResolver;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.annotation.FacesConfig;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.FacesContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.myfaces.cdi.config.FacesConfigBeanHolder;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.el.TracingELResolverWrapper;
import org.apache.myfaces.util.ExternalSpecifications;

public class ELResolverBuilder {
    private static final Logger log = Logger.getLogger(ELResolverBuilder.class.getName());
    protected final RuntimeConfig runtimeConfig;
    protected final MyfacesConfig myfacesConfig;

    public ELResolverBuilder(RuntimeConfig runtimeConfig, MyfacesConfig myfacesConfig) {
        this.runtimeConfig = runtimeConfig;
        this.myfacesConfig = myfacesConfig;
    }

    protected void addFromRuntimeConfig(List<ELResolver> resolvers) {
        if (this.runtimeConfig.getFacesConfigElResolvers() != null) {
            resolvers.addAll(this.runtimeConfig.getFacesConfigElResolvers());
        }
        if (this.runtimeConfig.getApplicationElResolvers() != null) {
            resolvers.addAll(this.runtimeConfig.getApplicationElResolvers());
        }
    }

    protected List<ELResolver> wrapELResolvers(List<ELResolver> resolvers) {
        if (!this.myfacesConfig.isElResolverTracing() || this.myfacesConfig.getProjectStage() != ProjectStage.Development) {
            return resolvers;
        }
        return resolvers.stream().map(r -> new TracingELResolverWrapper((ELResolver)r)).collect(Collectors.toList());
    }

    protected void sortELResolvers(List<ELResolver> resolvers) {
        if (this.runtimeConfig.getELResolverComparator() != null) {
            try {
                Collections.sort(resolvers, this.runtimeConfig.getELResolverComparator());
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Chain of EL resolvers sorted with: {1} and the result order is {2}", new Object[]{this.runtimeConfig.getELResolverComparator(), resolvers});
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not sort ELResolvers with custom Comparator", e);
            }
        }
    }

    protected Iterable<ELResolver> filterELResolvers(List<ELResolver> resolvers) {
        Predicate<ELResolver> predicate = this.runtimeConfig.getELResolverPredicate();
        if (predicate != null) {
            try {
                resolvers.removeIf(elResolver -> !predicate.test((ELResolver)elResolver));
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Chain of EL resolvers filtered with: {1} and the result is {2}", new Object[]{predicate, resolvers});
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not filter ELResolvers with custom Predicate", e);
            }
        }
        return resolvers;
    }

    protected boolean isReplaceImplicitObjectResolverWithCDIResolver(FacesContext facesContext) {
        FacesConfigBeanHolder holder;
        if (!ExternalSpecifications.isCDIAvailable(facesContext.getExternalContext())) {
            return false;
        }
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
        if (beanManager != null && (holder = CDIUtils.get(beanManager, FacesConfigBeanHolder.class)) != null) {
            FacesConfig.Version version = holder.getFacesConfigVersion();
            if (version == null) {
                return false;
            }
            return version.ordinal() >= FacesConfig.Version.JSF_2_3.ordinal();
        }
        return false;
    }

    public void build(CompositeELResolver elResolver) {
        this.build(FacesContext.getCurrentInstance(), elResolver);
    }

    public void build(FacesContext facesContext, CompositeELResolver elResolver) {
    }
}

