/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.html;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.FaceletContext;
import java.util.Iterator;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.RelocatableResourceHandler;
import org.apache.myfaces.view.facelets.tag.jsf.html.HtmlComponentHandler;

public class HtmlOutputScriptHandler
extends HtmlComponentHandler
implements RelocatableResourceHandler {
    public HtmlOutputScriptHandler(ComponentConfig config) {
        super(config);
    }

    @Override
    public UIComponent findChildByTagId(FaceletContext ctx, UIComponent parent, String id) {
        UIComponent c = ComponentSupport.findChildByTagId(parent, id);
        if (c == null) {
            UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
            if (root.getFacetCount() > 0) {
                Iterator<UIComponent> itr = root.getFacets().values().iterator();
                while (itr.hasNext() && c == null) {
                    UIComponent facet = itr.next();
                    c = ComponentSupport.findChildByTagId(facet, id);
                }
            }
            return c;
        }
        return c;
    }

    @Override
    public void onComponentCreated(FaceletContext ctx, UIComponent c, UIComponent parent) {
        UIComponent parentCompositeComponent = FaceletCompositionContext.getCurrentInstance(ctx).getCompositeComponentFromStack();
        if (parentCompositeComponent != null) {
            c.getAttributes().put("org.apache.myfaces.compositecomponent.location", parentCompositeComponent.getAttributes().get("org.apache.myfaces.compositecomponent.location"));
        }
    }
}

