/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.faces.context.ExternalContext;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.push.cdi.WebsocketSessionBean;

public class WebsocketConfigurator
extends ServerEndpointConfig.Configurator {
    public static final String MAX_IDLE_TIMEOUT = "oam.websocket.maxIdleTimeout";
    public static final String WEBSOCKET_VALID = "oam.websocket.valid";
    public static final String WEBSOCKET_USER = "oam.websocket.user";
    private final Long maxIdleTimeout;

    public WebsocketConfigurator(ExternalContext context) {
        this.maxIdleTimeout = MyfacesConfig.getCurrentInstance(context).getWebsocketMaxIdleTimeout();
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        BeanManager beanManager;
        WebsocketSessionBean websocketSessionBean;
        String channelToken;
        if (this.maxIdleTimeout != null) {
            sec.getUserProperties().put(MAX_IDLE_TIMEOUT, this.maxIdleTimeout);
        }
        if ((channelToken = request.getQueryString()) == null) {
            String uri = request.getRequestURI().toString();
            channelToken = uri.indexOf(63) >= 0 ? uri.substring(uri.indexOf(63) + 1) : uri.substring(uri.lastIndexOf(47) + 1);
        }
        if ((websocketSessionBean = CDIUtils.get(beanManager = CDI.current().getBeanManager(), WebsocketSessionBean.class, false, new Annotation[0])) != null) {
            Serializable user = websocketSessionBean.getUserFromChannelToken(channelToken);
            if (user != null) {
                sec.getUserProperties().put(WEBSOCKET_USER, user);
            }
            sec.getUserProperties().put(WEBSOCKET_VALID, websocketSessionBean.isTokenValid(channelToken));
        } else {
            sec.getUserProperties().put(WEBSOCKET_VALID, false);
        }
    }
}

