/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.webapp.FacetTag;
import javax.faces.webapp._DummyPageContextOutWriter;
import javax.faces.webapp._PageContextOutWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UIComponentTag
implements Tag {
    private static final String FORMER_CHILD_IDS_SET_ATTR = UIComponentTag.class.getName() + ".FORMER_CHILD_IDS";
    private static final String FORMER_FACET_NAMES_SET_ATTR = UIComponentTag.class.getName() + ".FORMER_FACET_NAMES";
    private static final String COMPONENT_STACK_ATTR = UIComponentTag.class.getName() + ".COMPONENT_STACK";
    private static final String UNIQUE_ID_COUNTER_ATTR = UIComponentTag.class.getName() + ".UNIQUE_ID_COUNTER";
    private static final String PARTIAL_STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING_METHOD";
    private static final String PARTIAL_STATE_SAVING_METHOD_ON = "true";
    private static final String PARTIAL_STATE_SAVING_METHOD_OFF = "false";
    private static final String BEFORE_VIEW_CONTEXT = "org.apache.myfaces.BEFORE_VIEW_CONTEXT";
    protected PageContext pageContext = null;
    private Tag _parent = null;
    private String _binding = null;
    private String _id = null;
    private String _rendered = null;
    private FacesContext _facesContext = null;
    private UIComponent _componentInstance = null;
    private boolean _created = false;
    private Boolean _suppressed = null;
    private ResponseWriter _writer = null;
    private Set _childrenAdded = null;
    private Set _facetsAdded = null;
    private Boolean _partialStateSaving = null;
    private static Log log = LogFactory.getLog((Class)UIComponentTag.class);
    private static final int READ_LENGTH = 8000;

    private boolean isPartialStateSavingOn(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._partialStateSaving != null) {
            return this._partialStateSaving;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(PARTIAL_STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING_METHOD' found; no partial state saving method defined, assuming default partial state saving method off.");
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_ON)) {
            this._partialStateSaving = Boolean.TRUE;
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_OFF)) {
            this._partialStateSaving = Boolean.FALSE;
        } else {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("Illegal context init parameter 'javax.faces.PARTIAL_STATE_SAVING_METHOD' found; illegal partial state saving method '" + stateSavingMethod + "', default partial state saving will be used (partial state saving off).");
        }
        return this._partialStateSaving;
    }

    public void release() {
        this.internalRelease();
        this.pageContext = null;
        this._parent = null;
        this._binding = null;
        this._id = null;
        this._rendered = null;
    }

    private void internalRelease() {
        this._facesContext = null;
        this._componentInstance = null;
        this._created = false;
        this._suppressed = null;
        this._writer = null;
        this._childrenAdded = null;
        this._facetsAdded = null;
    }

    public void setBinding(String binding) throws JspException {
        if (!UIComponentTag.isValueReference(binding)) {
            throw new IllegalArgumentException("not a valid binding: " + binding);
        }
        this._binding = binding;
    }

    public void setId(String id) {
        this._id = id;
    }

    protected String getId() {
        return this._id;
    }

    public void setRendered(String rendered) {
        this._rendered = rendered;
    }

    public abstract String getComponentType();

    public UIComponent getComponentInstance() {
        return this._componentInstance;
    }

    public boolean getCreated() {
        return this._created;
    }

    public static UIComponentTag getParentUIComponentTag(PageContext pageContext) {
        List list = (List)pageContext.getAttribute(COMPONENT_STACK_ATTR, 2);
        if (list != null) {
            return (UIComponentTag)list.get(list.size() - 1);
        }
        return null;
    }

    private void popTag() {
        List list = (List)this.pageContext.getAttribute(COMPONENT_STACK_ATTR, 2);
        if (list != null) {
            int size = list.size();
            list.remove(size - 1);
            if (size <= 1) {
                this.pageContext.removeAttribute(COMPONENT_STACK_ATTR, 2);
            }
        }
    }

    private void pushTag() {
        ArrayList<UIComponentTag> list = (ArrayList<UIComponentTag>)this.pageContext.getAttribute(COMPONENT_STACK_ATTR, 2);
        if (list == null) {
            list = new ArrayList<UIComponentTag>();
            this.pageContext.setAttribute(COMPONENT_STACK_ATTR, list, 2);
        }
        list.add(this);
    }

    public abstract String getRendererType();

    public static boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Tag getParent() {
        return this._parent;
    }

    public void setParent(Tag parent) {
        this._parent = parent;
    }

    private void flushWriter(JspWriter writerToFlush) throws JspException, IOException {
        if (this.getFacesContext() == null) {
            return;
        }
        this._componentInstance = this.findComponent(this._facesContext);
        if (writerToFlush instanceof BodyContent) {
            int count = 0;
            char[] readChars = new char[8000];
            BodyContent tempwriter = (BodyContent)writerToFlush;
            Reader read = tempwriter.getReader();
            count = read.read(readChars, 0, 8000);
            String readString = new String(readChars, 0, count);
            if (!readString.trim().equals("")) {
                UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
                this.addOutputComponentAfterComponent(parentTag, this.createUIOutputComponentFromString(readString), this._componentInstance);
                tempwriter.clearBody();
            }
        } else if (this._componentInstance.getParent() == null) {
            writerToFlush.flush();
            String beforeViewContent = this._facesContext.getExternalContext().getResponse().toString();
            if (beforeViewContent != null && !beforeViewContent.trim().equals("")) {
                this._facesContext.getExternalContext().getRequestMap().put(BEFORE_VIEW_CONTEXT, beforeViewContent);
            }
        }
    }

    private void addOutputComponentAfterComponent(UIComponentTag parentTag, UIComponent outputComponent, UIComponent component) {
        int indexOfComponentInParent = 0;
        UIComponent parent = component.getParent();
        if (null == parent) {
            return;
        }
        List children = parent.getChildren();
        indexOfComponentInParent = children.indexOf(component);
        if (children.size() - 1 == indexOfComponentInParent) {
            children.add(outputComponent);
        } else {
            children.add(indexOfComponentInParent + 1, outputComponent);
        }
        parentTag.addChildIdToParentTag(parentTag, outputComponent.getId());
    }

    private UIComponent createUIOutputComponentFromString(String content) {
        UIOutput outputComponent = null;
        outputComponent = this.createUIOutputComponent(this.getFacesContext());
        outputComponent.setValue(content);
        return outputComponent;
    }

    private UIOutput createUIOutputComponent(FacesContext context) {
        if (context == null) {
            return null;
        }
        UIOutput outputComponent = null;
        Application application = context.getApplication();
        outputComponent = (UIOutput)application.createComponent("javax.faces.HtmlOutputText");
        outputComponent.setTransient(true);
        outputComponent.getAttributes().put("escape", Boolean.FALSE);
        outputComponent.setId(context.getViewRoot().createUniqueId());
        return outputComponent;
    }

    public int doStartTag() throws JspException {
        UIComponent component;
        this.setupResponseWriter();
        FacesContext facesContext = this.getFacesContext();
        if (this.isPartialStateSavingOn(facesContext)) {
            JspWriter writer = this.pageContext.getOut();
            try {
                this.flushWriter(writer);
            }
            catch (IOException e) {
                log.error((Object)e.toString());
            }
        }
        if (!(component = this.findComponent(facesContext)).getRendersChildren() && !this.isSuppressed()) {
            try {
                this.encodeBegin();
                this._writer.flush();
            }
            catch (IOException e) {
                throw new JspException(e.getMessage(), (Throwable)e);
            }
        }
        this.pushTag();
        return this.getDoStartValue();
    }

    public int doEndTag() throws JspException {
        if (this.isPartialStateSavingOn(this.getFacesContext())) {
            JspWriter writerToFlush = this.pageContext.getOut();
            if (this._componentInstance == null) {
                this.findComponent(this.getFacesContext());
            }
            if (!(writerToFlush instanceof BodyContent) && this._componentInstance.getParent() == null) {
                this._componentInstance.getChildren().add(0, this.createUIOutputComponentFromString((String)this._facesContext.getExternalContext().getRequestMap().get(BEFORE_VIEW_CONTEXT)));
                this._facesContext.getExternalContext().getRequestMap().remove(BEFORE_VIEW_CONTEXT);
            }
        }
        this.popTag();
        UIComponent component = this.getComponentInstance();
        this.removeFormerChildren(component);
        this.removeFormerFacets(component);
        try {
            if (!this.isSuppressed()) {
                if (component.getRendersChildren()) {
                    this.encodeBegin();
                    this.encodeChildren();
                }
                this.encodeEnd();
            }
        }
        catch (IOException e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
        int retValue = this.getDoEndValue();
        this.internalRelease();
        return retValue;
    }

    private void removeFormerChildren(UIComponent component) {
        Set formerChildIdsSet = (Set)component.getAttributes().get(FORMER_CHILD_IDS_SET_ATTR);
        if (formerChildIdsSet != null) {
            Iterator iterator = formerChildIdsSet.iterator();
            while (iterator.hasNext()) {
                UIComponent childToRemove;
                String childId = (String)iterator.next();
                if (this._childrenAdded != null && this._childrenAdded.contains(childId) || (childToRemove = component.findComponent(childId)) == null) continue;
                component.getChildren().remove(childToRemove);
            }
            if (this._childrenAdded == null) {
                component.getAttributes().remove(FORMER_CHILD_IDS_SET_ATTR);
            } else {
                component.getAttributes().put(FORMER_CHILD_IDS_SET_ATTR, this._childrenAdded);
            }
        } else if (this._childrenAdded != null) {
            component.getAttributes().put(FORMER_CHILD_IDS_SET_ATTR, this._childrenAdded);
        }
    }

    private void removeFormerFacets(UIComponent component) {
        Set formerFacetNamesSet = (Set)component.getAttributes().get(FORMER_FACET_NAMES_SET_ATTR);
        if (formerFacetNamesSet != null) {
            Iterator iterator = formerFacetNamesSet.iterator();
            while (iterator.hasNext()) {
                String facetName = (String)iterator.next();
                if (this._facetsAdded != null && this._facetsAdded.contains(facetName)) continue;
                component.getFacets().remove(facetName);
            }
            if (this._facetsAdded == null) {
                component.getAttributes().remove(FORMER_FACET_NAMES_SET_ATTR);
            } else {
                component.getAttributes().put(FORMER_FACET_NAMES_SET_ATTR, this._facetsAdded);
            }
        } else if (this._facetsAdded != null) {
            component.getAttributes().put(FORMER_FACET_NAMES_SET_ATTR, this._facetsAdded);
        }
    }

    protected void encodeBegin() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entered encodeBegin for client-Id: " + this._componentInstance.getClientId(this.getFacesContext())));
        }
        this._componentInstance.encodeBegin(this.getFacesContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exited encodeBegin");
        }
    }

    protected void encodeChildren() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entered encodeChildren for client-Id: " + this._componentInstance.getClientId(this.getFacesContext())));
        }
        this._componentInstance.encodeChildren(this.getFacesContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exited encodeChildren for client-Id: " + this._componentInstance.getClientId(this.getFacesContext())));
        }
    }

    protected void encodeEnd() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entered encodeEnd for client-Id: " + this._componentInstance.getClientId(this.getFacesContext())));
        }
        this._componentInstance.encodeEnd(this.getFacesContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exited encodeEnd for client-Id: " + this._componentInstance.getClientId(this.getFacesContext())));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UIComponent findComponent(FacesContext context) throws JspException {
        if (this._componentInstance != null) {
            return this._componentInstance;
        }
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (parentTag == null) {
            this._componentInstance = context.getViewRoot();
            this.setProperties(this._componentInstance);
            return this._componentInstance;
        }
        UIComponent parent = parentTag.getComponentInstance();
        if (parent == null) {
            throw new IllegalStateException("parent is null?");
        }
        String facetName = this.getFacetName();
        if (facetName != null) {
            String id = this.getOrCreateUniqueId(context);
            this._componentInstance = parent.getFacet(facetName);
            if (this._componentInstance == null) {
                this._componentInstance = this.createComponentInstance(context, id);
                this.setProperties(this._componentInstance);
                parent.getFacets().put(facetName, this._componentInstance);
            } else if (this.checkFacetNameOnParentExists(parentTag, facetName)) {
                throw new IllegalStateException("facet '" + facetName + "' already has a child associated. current associated component id: " + this._componentInstance.getClientId(context) + " class: " + this._componentInstance.getClass().getName());
            }
            this.addFacetNameToParentTag(parentTag, facetName);
            return this._componentInstance;
        }
        String id = this.getOrCreateUniqueId(context);
        if (parentTag._childrenAdded != null && parentTag._childrenAdded.contains(id)) {
            throw new FacesException("There is more than one JSF tag with id : " + id + " for parent component with id : '" + parent.getId() + "'");
        }
        this._componentInstance = this.findComponent(parent, id);
        if (this._componentInstance == null) {
            this._componentInstance = this.createComponentInstance(context, id);
            if (id.equals(this._componentInstance.getId())) {
                this.setProperties(this._componentInstance);
                int index = this.getAddedChildrenCount(parentTag);
                List children = parent.getChildren();
                if (index > children.size()) throw new FacesException("cannot add component with id '" + this._componentInstance.getId() + " to its parent component with id : '" + parent.getId() + "' and path '" + this.getPathToComponent(parent) + "'at position :" + index + " in list of children. " + "This might be a problem due to a duplicate id in a previously added component," + "if this is the case, the problematic id might be one of : " + this.printSet(parentTag._childrenAdded));
                children.add(index, this._componentInstance);
            } else if (null == this.findComponent(parent, this._componentInstance.getId())) {
                this.setProperties(this._componentInstance);
                int index = this.getAddedChildrenCount(parentTag);
                List children = parent.getChildren();
                if (index > children.size()) throw new FacesException("cannot add component with id '" + this._componentInstance.getId() + " to its parent component with id : '" + parent.getId() + "' and path '" + this.getPathToComponent(parent) + "'at position :" + index + " in list of children. " + "This might be a problem due to a duplicate id in a previously added component," + "if this is the case, the problematic id might be one of : " + this.printSet(parentTag._childrenAdded));
                children.add(index, this._componentInstance);
            }
        }
        this.addChildIdToParentTag(parentTag, id);
        return this._componentInstance;
    }

    private UIComponent findComponent(UIComponent parent, String id) {
        List li = parent.getChildren();
        for (int i = 0; i < li.size(); ++i) {
            UIComponent uiComponent = (UIComponent)li.get(i);
            if (uiComponent.getId() == null || !uiComponent.getId().equals(id)) continue;
            return uiComponent;
        }
        return null;
    }

    private String printSet(Set childrenAdded) {
        StringBuffer buf = new StringBuffer();
        if (childrenAdded != null) {
            Iterator it = childrenAdded.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                buf.append(obj);
                if (!it.hasNext()) continue;
                buf.append(",");
            }
        }
        return buf.toString();
    }

    private String getOrCreateUniqueId(FacesContext context) {
        String id = this.getId();
        if (id != null) {
            return id;
        }
        Long currentCounter = (Long)context.getExternalContext().getRequestMap().get(UNIQUE_ID_COUNTER_ATTR);
        long lCurrentCounter = 0L;
        if (currentCounter != null) {
            lCurrentCounter = currentCounter;
        }
        StringBuffer retValue = new StringBuffer("_id");
        retValue.append("Jsp");
        retValue.append(lCurrentCounter);
        context.getExternalContext().getRequestMap().put(UNIQUE_ID_COUNTER_ATTR, new Long(++lCurrentCounter));
        ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
        return extCtx.encodeNamespace(retValue.toString());
    }

    private UIComponent createComponentInstance(FacesContext context, String id) {
        String componentType = this.getComponentType();
        if (componentType == null) {
            throw new NullPointerException("componentType");
        }
        if (this._binding != null) {
            Application application = context.getApplication();
            ValueBinding componentBinding = application.createValueBinding(this._binding);
            UIComponent component = application.createComponent(componentBinding, context, componentType);
            component.setId(id);
            component.setValueBinding("binding", componentBinding);
            this.recurseFacetsAndChildrenForId(component.getFacetsAndChildren(), id + "_", 0);
            this._created = true;
            return component;
        }
        UIComponent component = context.getApplication().createComponent(componentType);
        component.setId(id);
        this._created = true;
        return component;
    }

    private int recurseFacetsAndChildrenForId(Iterator facetsAndChildren, String idPrefix, int cnt) {
        while (facetsAndChildren.hasNext()) {
            UIComponent comp = (UIComponent)facetsAndChildren.next();
            if (comp.getId() == null) {
                comp.setId(idPrefix + ++cnt);
            }
            cnt = this.recurseFacetsAndChildrenForId(comp.getFacetsAndChildren(), idPrefix, cnt);
        }
        return cnt;
    }

    private void addChildIdToParentTag(UIComponentTag parentTag, String id) {
        if (parentTag._childrenAdded == null) {
            parentTag._childrenAdded = new HashSet();
        }
        parentTag._childrenAdded.add(id);
    }

    private boolean checkFacetNameOnParentExists(UIComponentTag parentTag, String facetName) {
        return parentTag._facetsAdded != null && parentTag._facetsAdded.contains(facetName);
    }

    private void addFacetNameToParentTag(UIComponentTag parentTag, String facetName) {
        if (parentTag._facetsAdded == null) {
            parentTag._facetsAdded = new HashSet();
        }
        parentTag._facetsAdded.add(facetName);
    }

    private int getAddedChildrenCount(UIComponentTag parentTag) {
        return parentTag._childrenAdded != null ? parentTag._childrenAdded.size() : 0;
    }

    protected int getDoStartValue() throws JspException {
        return 1;
    }

    protected int getDoEndValue() throws JspException {
        return 6;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            this._facesContext = FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    private boolean isFacet() {
        return this._parent != null && this._parent instanceof FacetTag;
    }

    protected String getFacetName() {
        return this.isFacet() ? ((FacetTag)this._parent).getName() : null;
    }

    protected boolean isSuppressed() {
        if (this._suppressed == null) {
            if (this.isFacet()) {
                this._suppressed = Boolean.TRUE;
                return true;
            }
            UIComponent component = this.getComponentInstance();
            for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.getRendersChildren()) continue;
                this._suppressed = Boolean.TRUE;
                return true;
            }
            while (component != null) {
                if (!component.isRendered()) {
                    this._suppressed = Boolean.TRUE;
                    return true;
                }
                component = component.getParent();
            }
            this._suppressed = Boolean.FALSE;
        }
        return this._suppressed;
    }

    protected void setProperties(UIComponent component) {
        if (this.getRendererType() != null) {
            this._componentInstance.setRendererType(this.getRendererType());
        }
        if (this._rendered != null) {
            if (UIComponentTag.isValueReference(this._rendered)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(this._rendered);
                component.setValueBinding("rendered", vb);
            } else {
                boolean b = Boolean.valueOf(this._rendered);
                component.setRendered(b);
            }
        }
    }

    protected void setupResponseWriter() {
        FacesContext facesContext = this.getFacesContext();
        if (facesContext == null) {
            throw new FacesException("Faces context not found. getResponseWriter will fail. Check if the FacesServlet has been initialized at all in your web.xml configuration fileand if you are accessing your jsf-pages through the correct mapping. E.g.: if your FacesServlet is mapped to  *.jsf (with the <servlet-mapping>-element), you need to access your pages as 'sample.jsf'. If you tried to access 'sample.jsp', you'd get this error-message.");
        }
        this._writer = facesContext.getResponseWriter();
        if (this._writer == null) {
            RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
            RenderKit renderKit = renderFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
            this._writer = this.isPartialStateSavingOn(facesContext) ? renderKit.createResponseWriter(new _DummyPageContextOutWriter(this.pageContext), null, this.pageContext.getRequest().getCharacterEncoding()) : renderKit.createResponseWriter(new _PageContextOutWriter(this.pageContext), null, this.pageContext.getRequest().getCharacterEncoding());
            facesContext.setResponseWriter(this._writer);
        }
    }

    private String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        UIComponentTag.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, (Object)intBuf);
        UIComponentTag.getPathToComponent(component.getParent(), buf);
    }
}

