/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.internal.InputStreams;
import org.assertj.core.internal.InputStreamsException;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractInputStreamAssert<SELF extends AbstractInputStreamAssert<SELF, ACTUAL>, ACTUAL extends InputStream>
extends AbstractAssert<SELF, ACTUAL> {
    @VisibleForTesting
    InputStreams inputStreams = InputStreams.instance();

    protected AbstractInputStreamAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @CheckReturnValue
    public AbstractStringAssert<?> asString(Charset charset) {
        Objects.requireNonNull(charset, "The charset for converting to a String must not be null");
        this.objects.assertNotNull(this.info, this.actual);
        String actualAsString = this.readString(charset);
        return Assertions.assertThat(actualAsString);
    }

    @Deprecated
    public SELF hasContentEqualTo(InputStream expected) {
        return this.hasSameContentAs(expected);
    }

    public SELF hasSameContentAs(InputStream expected) {
        this.inputStreams.assertSameContentAs(this.info, (InputStream)this.actual, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF isEmpty() {
        this.isNotNull();
        this.assertIsEmpty();
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertIsEmpty() {
        try {
            if (((InputStream)this.actual).read() != -1) {
                throw this.assertionError(ShouldBeEmpty.shouldBeEmpty(this.actual));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SELF isNotEmpty() {
        this.isNotNull();
        this.assertIsNotEmpty();
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private void assertIsNotEmpty() {
        try {
            if (((InputStream)this.actual).read() == -1) {
                throw this.assertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SELF hasContent(String expected) {
        this.inputStreams.assertHasContent(this.info, (InputStream)this.actual, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasBinaryContent(byte[] expected) {
        this.inputStreams.assertHasBinaryContent(this.info, (InputStream)this.actual, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasDigest(MessageDigest digest, byte[] expected) {
        this.inputStreams.assertHasDigest((AssertionInfo)this.info, (InputStream)this.actual, digest, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasDigest(MessageDigest digest, String expected) {
        this.inputStreams.assertHasDigest((AssertionInfo)this.info, (InputStream)this.actual, digest, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, byte[] expected) {
        this.inputStreams.assertHasDigest((AssertionInfo)this.info, (InputStream)this.actual, algorithm, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    public SELF hasDigest(String algorithm, String expected) {
        this.inputStreams.assertHasDigest((AssertionInfo)this.info, (InputStream)this.actual, algorithm, expected);
        return (SELF)((AbstractInputStreamAssert)this.myself);
    }

    private String readString(Charset charset) {
        try {
            int read;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((read = ((InputStream)this.actual).read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            return new String(buffer.toByteArray(), charset);
        }
        catch (IOException e) {
            throw new InputStreamsException("Unable to read contents of InputStreams actual", e);
        }
    }
}

