/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.apache.maven.api.Service;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;

@Experimental
public interface Interpolator
extends Service {
    default public void interpolate(@Nonnull Map<String, String> properties, @Nullable UnaryOperator<String> callback) {
        this.interpolate(properties, callback, null, true);
    }

    default public void interpolate(@Nonnull Map<String, String> map, @Nullable UnaryOperator<String> callback, boolean defaultsToEmpty) {
        this.interpolate(map, callback, null, defaultsToEmpty);
    }

    public void interpolate(@Nonnull Map<String, String> var1, @Nullable UnaryOperator<String> var2, @Nullable BinaryOperator<String> var3, boolean var4);

    @Nullable
    default public String interpolate(@Nullable String val, @Nullable UnaryOperator<String> callback) {
        return this.interpolate(val, callback, false);
    }

    @Nullable
    default public String interpolate(@Nullable String val, @Nullable UnaryOperator<String> callback, boolean defaultsToEmpty) {
        return this.interpolate(val, callback, null, defaultsToEmpty);
    }

    @Nullable
    public String interpolate(@Nullable String var1, @Nullable UnaryOperator<String> var2, @Nullable BinaryOperator<String> var3, boolean var4);

    public static UnaryOperator<String> chain(Collection<? extends UnaryOperator<String>> functions) {
        return s -> {
            for (UnaryOperator function : functions) {
                String v = (String)function.apply(s);
                if (v == null) continue;
                return v;
            }
            return null;
        };
    }

    @SafeVarargs
    public static UnaryOperator<String> chain(UnaryOperator<String> ... functions) {
        return Interpolator.chain(List.of(functions));
    }

    public static UnaryOperator<String> memoize(UnaryOperator<String> callback) {
        HashMap cache = new HashMap();
        return s -> cache.computeIfAbsent(s, v -> Optional.ofNullable((String)callback.apply((String)v))).orElse(null);
    }
}

