/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model.rootlocator;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.services.model.RootDetector;
import org.apache.maven.api.services.model.RootLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultRootLocator
implements RootLocator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<RootDetector> rootDetectors = ServiceLoader.load(RootDetector.class).stream().map(ServiceLoader.Provider::get).toList();

    @Override
    public Path findRoot(Path basedir) {
        Path rootDirectory;
        Objects.requireNonNull(basedir, this.getNoRootMessage());
        for (rootDirectory = basedir; rootDirectory != null && !this.isRootDirectory(rootDirectory); rootDirectory = rootDirectory.getParent()) {
        }
        return rootDirectory;
    }

    @Override
    @Nonnull
    public Path findMandatoryRoot(@Nonnull Path basedir) {
        Path rootDirectory = this.findRoot(basedir);
        Optional<Path> rdf = this.getRootDirectoryFallback();
        if (rootDirectory == null) {
            rootDirectory = rdf.orElseThrow(() -> new IllegalStateException(this.getNoRootMessage()));
            this.logger.warn(this.getNoRootMessage());
        } else if (rdf.isPresent() && !Objects.equals(rootDirectory, rdf.get())) {
            this.logger.warn("Project root directory and multiModuleProjectDirectory are not aligned");
        }
        return rootDirectory;
    }

    protected boolean isRootDirectory(Path dir) {
        Objects.requireNonNull(dir, "dir is null");
        for (RootDetector rootDetector : this.rootDetectors) {
            if (!rootDetector.isRootDirectory(dir)) continue;
            return true;
        }
        return false;
    }

    protected Optional<Path> getRootDirectoryFallback() {
        String mmpd = System.getProperty("maven.multiModuleProjectDirectory");
        if (mmpd != null) {
            return Optional.of(Paths.get(mmpd, new String[0]));
        }
        return Optional.empty();
    }
}

