/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.graph.Exclusion;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.eclipse.aether.version.VersionConstraint;

public class DependencyGraphDumper
implements DependencyVisitor {
    private static final List<Function<DependencyNode, String>> DEFAULT_DECORATORS = Collections.unmodifiableList(Arrays.asList(DependencyGraphDumper.effectiveDependency(), DependencyGraphDumper.premanagedVersion(), DependencyGraphDumper.premanagedScope(), DependencyGraphDumper.premanagedOptional(), DependencyGraphDumper.premanagedExclusions(), DependencyGraphDumper.premanagedProperties(), DependencyGraphDumper.rangeMember(), DependencyGraphDumper.winnerNode()));
    private final Consumer<String> consumer;
    private final List<Function<DependencyNode, String>> decorators;
    private final Deque<DependencyNode> nodes = new ArrayDeque<DependencyNode>();

    public static Function<DependencyNode, String> effectiveDependency() {
        return dependencyNode -> {
            Dependency d = dependencyNode.getDependency();
            if (d != null && !d.getScope().isEmpty()) {
                String result = d.getScope();
                if (d.isOptional()) {
                    result = result + ", optional";
                }
                return "[" + result + "]";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedVersion() {
        return dependencyNode -> {
            String premanagedVersion;
            if (dependencyNode.getArtifact() != null && (premanagedVersion = DependencyManagerUtils.getPremanagedVersion(dependencyNode)) != null && !premanagedVersion.equals(dependencyNode.getArtifact().getBaseVersion())) {
                return "(version managed from " + premanagedVersion + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedScope() {
        return dependencyNode -> {
            String premanagedScope;
            Dependency d = dependencyNode.getDependency();
            if (d != null && (premanagedScope = DependencyManagerUtils.getPremanagedScope(dependencyNode)) != null && !premanagedScope.equals(d.getScope())) {
                return "(scope managed from " + premanagedScope + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedOptional() {
        return dependencyNode -> {
            Boolean premanagedOptional;
            Dependency d = dependencyNode.getDependency();
            if (d != null && (premanagedOptional = DependencyManagerUtils.getPremanagedOptional(dependencyNode)) != null && !premanagedOptional.equals(d.getOptional())) {
                return "(optionality managed from " + premanagedOptional + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedExclusions() {
        return dependencyNode -> {
            Collection<Exclusion> premanagedExclusions;
            Dependency d = dependencyNode.getDependency();
            if (d != null && (premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions(dependencyNode)) != null && !DependencyGraphDumper.equals(premanagedExclusions, d.getExclusions())) {
                return "(exclusions managed from " + premanagedExclusions + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> premanagedProperties() {
        return dependencyNode -> {
            Map<String, String> premanagedProperties;
            if (dependencyNode.getArtifact() != null && (premanagedProperties = DependencyManagerUtils.getPremanagedProperties(dependencyNode)) != null && !DependencyGraphDumper.equals(premanagedProperties, dependencyNode.getArtifact().getProperties())) {
                return "(properties managed from " + premanagedProperties + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> rangeMember() {
        return dependencyNode -> {
            VersionConstraint constraint = dependencyNode.getVersionConstraint();
            if (constraint != null && constraint.getRange() != null) {
                return "(range '" + constraint.getRange() + "')";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> winnerNode() {
        return dependencyNode -> {
            DependencyNode winner;
            if (dependencyNode.getArtifact() != null && (winner = (DependencyNode)dependencyNode.getData().get("conflict.winner")) != null) {
                if (ArtifactIdUtils.equalsId(dependencyNode.getArtifact(), winner.getArtifact())) {
                    return "(nearer exists)";
                }
                Artifact w = winner.getArtifact();
                String result = "conflicts with ";
                result = ArtifactIdUtils.toVersionlessId(dependencyNode.getArtifact()).equals(ArtifactIdUtils.toVersionlessId(w)) ? result + w.getVersion() : result + w;
                return "(" + result + ")";
            }
            return null;
        };
    }

    public static Function<DependencyNode, String> artifactProperties(Collection<String> properties) {
        Objects.requireNonNull(properties, "properties");
        return dependencyNode -> {
            String props;
            if (!properties.isEmpty() && dependencyNode.getDependency() != null && !(props = properties.stream().map(p -> p + "=" + dependencyNode.getDependency().getArtifact().getProperty(p, "n/a")).collect(Collectors.joining(","))).isEmpty()) {
                return "(" + props + ")";
            }
            return null;
        };
    }

    public static List<Function<DependencyNode, String>> defaultsWith(Collection<Function<DependencyNode, String>> extras) {
        Objects.requireNonNull(extras, "extras");
        ArrayList<Function<DependencyNode, String>> result = new ArrayList<Function<DependencyNode, String>>(DEFAULT_DECORATORS);
        result.addAll(extras);
        return result;
    }

    public DependencyGraphDumper(Consumer<String> consumer) {
        this(consumer, DEFAULT_DECORATORS);
    }

    public DependencyGraphDumper(Consumer<String> consumer, Collection<Function<DependencyNode, String>> decorators) {
        this.consumer = Objects.requireNonNull(consumer);
        this.decorators = new ArrayList<Function<DependencyNode, String>>(decorators);
    }

    public boolean visitEnter(DependencyNode node) {
        this.nodes.push(node);
        this.consumer.accept(this.formatLine(this.nodes));
        return true;
    }

    public boolean visitLeave(DependencyNode node) {
        if (!this.nodes.isEmpty()) {
            this.nodes.pop();
        }
        return true;
    }

    protected String formatLine(Deque<DependencyNode> nodes) {
        return this.formatIndentation(nodes) + this.formatNode(nodes);
    }

    protected String formatIndentation(Deque<DependencyNode> nodes) {
        DependencyNode child;
        StringBuilder buffer = new StringBuilder(128);
        Iterator<DependencyNode> iter = nodes.descendingIterator();
        DependencyNode parent = iter.hasNext() ? iter.next() : null;
        DependencyNode dependencyNode = child = iter.hasNext() ? iter.next() : null;
        while (parent != null && child != null) {
            boolean end;
            boolean lastChild = parent.getChildren().get(parent.getChildren().size() - 1) == child;
            boolean bl = end = child == nodes.peekFirst();
            String indent = end ? (lastChild ? "\\- " : "+- ") : (lastChild ? "   " : "|  ");
            buffer.append(indent);
            parent = child;
            child = iter.hasNext() ? iter.next() : null;
        }
        return buffer.toString();
    }

    protected String formatNode(Deque<DependencyNode> nodes) {
        DependencyNode node = Objects.requireNonNull(nodes.peek(), "bug: should not happen");
        StringBuilder buffer = new StringBuilder(128);
        Artifact a = node.getArtifact();
        buffer.append(a);
        for (Function<DependencyNode, String> decorator : this.decorators) {
            String decoration = decorator.apply(node);
            if (decoration == null) continue;
            buffer.append(" ").append(decoration);
        }
        return buffer.toString();
    }

    private static boolean equals(Collection<Exclusion> c1, Collection<Exclusion> c2) {
        return c1 != null && c2 != null && c1.size() == c2.size() && c1.containsAll(c2);
    }

    private static boolean equals(Map<String, String> m1, Map<String, String> m2) {
        return m1 != null && m2 != null && m1.size() == m2.size() && m1.entrySet().stream().allMatch(entry -> Objects.equals(m2.get(entry.getKey()), entry.getValue()));
    }
}

