/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class NodeListGenerator
implements Consumer<DependencyNode> {
    private final ArrayList<DependencyNode> nodes = new ArrayList(128);

    @Override
    public void accept(DependencyNode dependencyNode) {
        this.nodes.add(dependencyNode);
    }

    public List<DependencyNode> getNodes() {
        return this.nodes;
    }

    public List<DependencyNode> getNodesWithDependencies() {
        return NodeListGenerator.getNodesWithDependencies(this.getNodes());
    }

    public List<Dependency> getDependencies(boolean includeUnresolved) {
        return NodeListGenerator.getDependencies(this.getNodes(), includeUnresolved);
    }

    public List<Artifact> getArtifacts(boolean includeUnresolved) {
        return NodeListGenerator.getArtifacts(this.getNodes(), includeUnresolved);
    }

    @Deprecated
    public List<File> getFiles() {
        return NodeListGenerator.getFiles(this.getNodes());
    }

    public List<Path> getPaths() {
        return NodeListGenerator.getPaths(this.getNodes());
    }

    public String getClassPath() {
        return NodeListGenerator.getClassPath(this.getNodes());
    }

    static List<DependencyNode> getNodesWithDependencies(List<DependencyNode> nodes) {
        return nodes.stream().filter(d -> d.getDependency() != null).collect(Collectors.toList());
    }

    static List<Dependency> getDependencies(List<DependencyNode> nodes, boolean includeUnresolved) {
        return NodeListGenerator.getNodesWithDependencies(nodes).stream().map(DependencyNode::getDependency).filter(d -> includeUnresolved || d.getArtifact().getPath() != null).collect(Collectors.toList());
    }

    static List<Artifact> getArtifacts(List<DependencyNode> nodes, boolean includeUnresolved) {
        return NodeListGenerator.getNodesWithDependencies(nodes).stream().map(d -> d.getDependency().getArtifact()).filter(artifact -> includeUnresolved || artifact.getPath() != null).collect(Collectors.toList());
    }

    @Deprecated
    static List<File> getFiles(List<DependencyNode> nodes) {
        return NodeListGenerator.getNodesWithDependencies(nodes).stream().map(d -> d.getDependency().getArtifact().getFile()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static List<Path> getPaths(List<DependencyNode> nodes) {
        return NodeListGenerator.getNodesWithDependencies(nodes).stream().map(d -> d.getDependency().getArtifact().getPath()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    static String getClassPath(List<DependencyNode> nodes) {
        return NodeListGenerator.getPaths(nodes).stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }
}

