/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.IAgent;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.NotificationConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.ReprioritizationTrackerFactory;
import org.apache.manifoldcf.crawler.system.AssessmentThread;
import org.apache.manifoldcf.crawler.system.DeleteStartupResetManager;
import org.apache.manifoldcf.crawler.system.DocCleanupResetManager;
import org.apache.manifoldcf.crawler.system.DocDeleteResetManager;
import org.apache.manifoldcf.crawler.system.DocumentCleanupQueue;
import org.apache.manifoldcf.crawler.system.DocumentCleanupStufferThread;
import org.apache.manifoldcf.crawler.system.DocumentCleanupThread;
import org.apache.manifoldcf.crawler.system.DocumentDeleteQueue;
import org.apache.manifoldcf.crawler.system.DocumentDeleteStufferThread;
import org.apache.manifoldcf.crawler.system.DocumentDeleteThread;
import org.apache.manifoldcf.crawler.system.DocumentQueue;
import org.apache.manifoldcf.crawler.system.ExpireStufferThread;
import org.apache.manifoldcf.crawler.system.ExpireThread;
import org.apache.manifoldcf.crawler.system.FinisherThread;
import org.apache.manifoldcf.crawler.system.HistoryCleanupThread;
import org.apache.manifoldcf.crawler.system.IdleCleanupThread;
import org.apache.manifoldcf.crawler.system.JobDeleteThread;
import org.apache.manifoldcf.crawler.system.JobNotificationThread;
import org.apache.manifoldcf.crawler.system.JobResetThread;
import org.apache.manifoldcf.crawler.system.JobStartThread;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.NotificationResetManager;
import org.apache.manifoldcf.crawler.system.SeedingResetManager;
import org.apache.manifoldcf.crawler.system.SeedingThread;
import org.apache.manifoldcf.crawler.system.SetPriorityThread;
import org.apache.manifoldcf.crawler.system.StartDeleteThread;
import org.apache.manifoldcf.crawler.system.StartupResetManager;
import org.apache.manifoldcf.crawler.system.StartupThread;
import org.apache.manifoldcf.crawler.system.StufferThread;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;
import org.apache.manifoldcf.crawler.system.WorkerThread;

public class CrawlerAgent
implements IAgent {
    public static final String _rcsid = "@(#)$Id: CrawlerAgent.java 988245 2010-08-23 18:39:35Z kwright $";
    protected JobStartThread jobStartThread = null;
    protected StufferThread stufferThread = null;
    protected FinisherThread finisherThread = null;
    protected JobNotificationThread notificationThread = null;
    protected StartupThread startupThread = null;
    protected StartDeleteThread startDeleteThread = null;
    protected JobDeleteThread jobDeleteThread = null;
    protected WorkerThread[] workerThreads = null;
    protected ExpireStufferThread expireStufferThread = null;
    protected ExpireThread[] expireThreads = null;
    protected DocumentDeleteStufferThread deleteStufferThread = null;
    protected DocumentDeleteThread[] deleteThreads = null;
    protected DocumentCleanupStufferThread cleanupStufferThread = null;
    protected DocumentCleanupThread[] cleanupThreads = null;
    protected JobResetThread jobResetThread = null;
    protected SeedingThread seedingThread = null;
    protected IdleCleanupThread idleCleanupThread = null;
    protected SetPriorityThread setPriorityThread = null;
    protected HistoryCleanupThread historyCleanupThread = null;
    protected AssessmentThread assessmentThread = null;
    protected WorkerResetManager workerResetManager = null;
    protected DocDeleteResetManager docDeleteResetManager = null;
    protected DocCleanupResetManager docCleanupResetManager = null;
    protected int numWorkerThreads = 0;
    protected int numDeleteThreads = 0;
    protected int numCleanupThreads = 0;
    protected int numExpireThreads = 0;
    protected float lowWaterFactor = 5.0f;
    protected float stuffAmtFactor = 0.5f;
    protected String processID = null;

    public void initialize(IThreadContext threadContext) throws ManifoldCFException {
        org.apache.manifoldcf.authorities.system.ManifoldCF.localInitialize(threadContext);
        ManifoldCF.localInitialize(threadContext);
    }

    public void cleanUp(IThreadContext threadContext) throws ManifoldCFException {
        ManifoldCF.localCleanup(threadContext);
        org.apache.manifoldcf.authorities.system.ManifoldCF.localCleanup(threadContext);
    }

    public void install(IThreadContext threadContext) throws ManifoldCFException {
        ManifoldCF.installSystemTables(threadContext);
    }

    public void deinstall(IThreadContext threadContext) throws ManifoldCFException {
        ManifoldCF.deinstallSystemTables(threadContext);
    }

    public void clusterInit(IThreadContext threadContext) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.prepareForClusterStart();
    }

    public void cleanUpAllAgentData(IThreadContext threadContext, String currentProcessID) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.cleanupProcessData();
        ManifoldCF.resetAllDocumentPriorities(threadContext, currentProcessID);
    }

    public void cleanUpAgentData(IThreadContext threadContext, String currentProcessID, String cleanupProcessID) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.cleanupProcessData(cleanupProcessID);
        IReprioritizationTracker rt = ReprioritizationTrackerFactory.make(threadContext);
        String reproID = rt.isSpecifiedProcessReprioritizing(cleanupProcessID);
        if (reproID != null) {
            jobManager.clearAllDocumentPriorities();
            rt.doneReprioritization(reproID);
        }
    }

    public void startAgent(IThreadContext threadContext, String processID) throws ManifoldCFException {
        this.processID = processID;
        this.startSystem(threadContext);
    }

    public void stopAgent(IThreadContext threadContext) throws ManifoldCFException {
        this.stopSystem(threadContext);
    }

    public boolean isOutputConnectionInUse(IThreadContext threadContext, String connName) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        return jobManager.checkIfOutputReference(connName);
    }

    public void noteOutputConnectorDeregistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteOutputConnectorDeregistration(connectionNames);
    }

    public void noteOutputConnectorRegistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteOutputConnectorRegistration(connectionNames);
    }

    public void noteOutputConnectionChange(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteOutputConnectionChange(connectionName);
    }

    public boolean isTransformationConnectionInUse(IThreadContext threadContext, String connName) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        return jobManager.checkIfTransformationReference(connName);
    }

    public void noteTransformationConnectorDeregistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteTransformationConnectorDeregistration(connectionNames);
    }

    public void noteTransformationConnectorRegistration(IThreadContext threadContext, String[] connectionNames) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteTransformationConnectorRegistration(connectionNames);
    }

    public void noteTransformationConnectionChange(IThreadContext threadContext, String connectionName) throws ManifoldCFException {
        IJobManager jobManager = JobManagerFactory.make(threadContext);
        jobManager.noteTransformationConnectionChange(connectionName);
    }

    public void startSystem(IThreadContext threadContext) throws ManifoldCFException {
        int i;
        Logging.root.info((Object)"Starting up pull-agent...");
        this.numWorkerThreads = ManifoldCF.getMaxWorkerThreads(threadContext);
        if (this.numWorkerThreads < 1 || this.numWorkerThreads > 300) {
            throw new ManifoldCFException("Illegal value for the number of worker threads", 3);
        }
        this.numDeleteThreads = ManifoldCF.getMaxDeleteThreads(threadContext);
        this.numCleanupThreads = ManifoldCF.getMaxCleanupThreads(threadContext);
        this.numExpireThreads = ManifoldCF.getMaxExpireThreads(threadContext);
        if (this.numDeleteThreads < 1 || this.numDeleteThreads > 300) {
            throw new ManifoldCFException("Illegal value for the number of delete threads", 3);
        }
        if (this.numCleanupThreads < 1 || this.numCleanupThreads > 300) {
            throw new ManifoldCFException("Illegal value for the number of cleanup threads", 3);
        }
        if (this.numExpireThreads < 1 || this.numExpireThreads > 300) {
            throw new ManifoldCFException("Illegal value for the number of expire threads", 3);
        }
        this.lowWaterFactor = (float)LockManagerFactory.getDoubleProperty((IThreadContext)threadContext, (String)"org.apache.manifoldcf.crawler.lowwaterfactor", (double)5.0);
        if ((double)this.lowWaterFactor < 1.0 || (double)this.lowWaterFactor > 1000.0) {
            throw new ManifoldCFException("Illegal value for the low water factor", 3);
        }
        this.stuffAmtFactor = (float)LockManagerFactory.getDoubleProperty((IThreadContext)threadContext, (String)"org.apache.manifoldcf.crawler.stuffamountfactor", (double)2.0);
        if ((double)this.stuffAmtFactor < 0.1 || (double)this.stuffAmtFactor > 1000.0) {
            throw new ManifoldCFException("Illegal value for the stuffing amount factor", 3);
        }
        QueueTracker queueTracker = new QueueTracker();
        DocumentQueue documentQueue = new DocumentQueue();
        DocumentDeleteQueue documentDeleteQueue = new DocumentDeleteQueue();
        DocumentCleanupQueue documentCleanupQueue = new DocumentCleanupQueue();
        DocumentCleanupQueue expireQueue = new DocumentCleanupQueue();
        BlockingDocuments blockingDocuments = new BlockingDocuments();
        this.workerResetManager = new WorkerResetManager(documentQueue, expireQueue, this.processID);
        this.docDeleteResetManager = new DocDeleteResetManager(documentDeleteQueue, this.processID);
        this.docCleanupResetManager = new DocCleanupResetManager(documentCleanupQueue, this.processID);
        this.jobStartThread = new JobStartThread(this.processID);
        this.startupThread = new StartupThread(new StartupResetManager(this.processID), this.processID);
        this.startDeleteThread = new StartDeleteThread(new DeleteStartupResetManager(this.processID), this.processID);
        this.finisherThread = new FinisherThread(this.processID);
        this.notificationThread = new JobNotificationThread(new NotificationResetManager(this.processID), this.processID);
        this.jobDeleteThread = new JobDeleteThread(this.processID);
        this.stufferThread = new StufferThread(documentQueue, this.numWorkerThreads, this.workerResetManager, queueTracker, blockingDocuments, this.lowWaterFactor, this.stuffAmtFactor, this.processID);
        this.expireStufferThread = new ExpireStufferThread(expireQueue, this.numExpireThreads, this.workerResetManager, this.processID);
        this.setPriorityThread = new SetPriorityThread(this.numWorkerThreads, blockingDocuments, this.processID);
        this.historyCleanupThread = new HistoryCleanupThread(this.processID);
        this.workerThreads = new WorkerThread[this.numWorkerThreads];
        for (i = 0; i < this.numWorkerThreads; ++i) {
            this.workerThreads[i] = new WorkerThread(Integer.toString(i), documentQueue, this.workerResetManager, queueTracker, this.processID);
        }
        this.expireThreads = new ExpireThread[this.numExpireThreads];
        for (i = 0; i < this.numExpireThreads; ++i) {
            this.expireThreads[i] = new ExpireThread(Integer.toString(i), expireQueue, this.workerResetManager, this.processID);
        }
        this.deleteStufferThread = new DocumentDeleteStufferThread(documentDeleteQueue, this.numDeleteThreads, this.docDeleteResetManager, this.processID);
        this.deleteThreads = new DocumentDeleteThread[this.numDeleteThreads];
        for (i = 0; i < this.numDeleteThreads; ++i) {
            this.deleteThreads[i] = new DocumentDeleteThread(Integer.toString(i), documentDeleteQueue, this.docDeleteResetManager, this.processID);
        }
        this.cleanupStufferThread = new DocumentCleanupStufferThread(documentCleanupQueue, this.numCleanupThreads, this.docCleanupResetManager, this.processID);
        this.cleanupThreads = new DocumentCleanupThread[this.numCleanupThreads];
        for (i = 0; i < this.numCleanupThreads; ++i) {
            this.cleanupThreads[i] = new DocumentCleanupThread(Integer.toString(i), documentCleanupQueue, this.docCleanupResetManager, this.processID);
        }
        this.jobResetThread = new JobResetThread(this.processID);
        this.seedingThread = new SeedingThread(new SeedingResetManager(this.processID), this.processID);
        this.idleCleanupThread = new IdleCleanupThread(this.processID);
        this.assessmentThread = new AssessmentThread(this.processID);
        this.jobStartThread.start();
        this.startupThread.start();
        this.startDeleteThread.start();
        this.finisherThread.start();
        this.notificationThread.start();
        this.jobDeleteThread.start();
        this.stufferThread.start();
        this.expireStufferThread.start();
        this.setPriorityThread.start();
        this.historyCleanupThread.start();
        for (i = 0; i < this.numWorkerThreads; ++i) {
            this.workerThreads[i].start();
        }
        for (i = 0; i < this.numExpireThreads; ++i) {
            this.expireThreads[i].start();
        }
        this.cleanupStufferThread.start();
        for (i = 0; i < this.numCleanupThreads; ++i) {
            this.cleanupThreads[i].start();
        }
        this.deleteStufferThread.start();
        for (i = 0; i < this.numDeleteThreads; ++i) {
            this.deleteThreads[i].start();
        }
        this.jobResetThread.start();
        this.seedingThread.start();
        this.idleCleanupThread.start();
        this.assessmentThread.start();
        Logging.root.info((Object)"Pull-agent started");
    }

    public void stopSystem(IThreadContext threadContext) throws ManifoldCFException {
        Logging.root.info((Object)"Shutting down pull-agent...");
        while (this.jobDeleteThread != null || this.startupThread != null || this.startDeleteThread != null || this.jobStartThread != null || this.stufferThread != null || this.finisherThread != null || this.notificationThread != null || this.workerThreads != null || this.expireStufferThread != null || this.expireThreads != null || this.deleteStufferThread != null || this.deleteThreads != null || this.cleanupStufferThread != null || this.cleanupThreads != null || this.jobResetThread != null || this.seedingThread != null || this.idleCleanupThread != null || this.assessmentThread != null || this.setPriorityThread != null || this.historyCleanupThread != null) {
            int i;
            if (this.historyCleanupThread != null) {
                this.historyCleanupThread.interrupt();
            }
            if (this.setPriorityThread != null) {
                this.setPriorityThread.interrupt();
            }
            if (this.jobStartThread != null) {
                this.jobStartThread.interrupt();
            }
            if (this.jobDeleteThread != null) {
                this.jobDeleteThread.interrupt();
            }
            if (this.startupThread != null) {
                this.startupThread.interrupt();
            }
            if (this.startDeleteThread != null) {
                this.startDeleteThread.interrupt();
            }
            if (this.stufferThread != null) {
                this.stufferThread.interrupt();
            }
            if (this.expireStufferThread != null) {
                this.expireStufferThread.interrupt();
            }
            if (this.finisherThread != null) {
                this.finisherThread.interrupt();
            }
            if (this.notificationThread != null) {
                this.notificationThread.interrupt();
            }
            if (this.workerThreads != null) {
                i = 0;
                while (i < this.workerThreads.length) {
                    WorkerThread workerThread;
                    if ((workerThread = this.workerThreads[i++]) == null) continue;
                    workerThread.interrupt();
                }
            }
            if (this.expireThreads != null) {
                i = 0;
                while (i < this.expireThreads.length) {
                    ExpireThread expireThread;
                    if ((expireThread = this.expireThreads[i++]) == null) continue;
                    expireThread.interrupt();
                }
            }
            if (this.cleanupStufferThread != null) {
                this.cleanupStufferThread.interrupt();
            }
            if (this.cleanupThreads != null) {
                i = 0;
                while (i < this.cleanupThreads.length) {
                    DocumentCleanupThread cleanupThread;
                    if ((cleanupThread = this.cleanupThreads[i++]) == null) continue;
                    cleanupThread.interrupt();
                }
            }
            if (this.deleteStufferThread != null) {
                this.deleteStufferThread.interrupt();
            }
            if (this.deleteThreads != null) {
                i = 0;
                while (i < this.deleteThreads.length) {
                    DocumentDeleteThread deleteThread;
                    if ((deleteThread = this.deleteThreads[i++]) == null) continue;
                    deleteThread.interrupt();
                }
            }
            if (this.jobResetThread != null) {
                this.jobResetThread.interrupt();
            }
            if (this.seedingThread != null) {
                this.seedingThread.interrupt();
            }
            if (this.idleCleanupThread != null) {
                this.idleCleanupThread.interrupt();
            }
            if (this.assessmentThread != null) {
                this.assessmentThread.interrupt();
            }
            try {
                ManifoldCF.sleep((long)1000L);
            }
            catch (InterruptedException i2) {
                // empty catch block
            }
            if (this.historyCleanupThread != null && !this.historyCleanupThread.isAlive()) {
                this.historyCleanupThread = null;
            }
            if (this.setPriorityThread != null && !this.setPriorityThread.isAlive()) {
                this.setPriorityThread = null;
            }
            if (this.jobDeleteThread != null && !this.jobDeleteThread.isAlive()) {
                this.jobDeleteThread = null;
            }
            if (this.startupThread != null && !this.startupThread.isAlive()) {
                this.startupThread = null;
            }
            if (this.startDeleteThread != null && !this.startDeleteThread.isAlive()) {
                this.startDeleteThread = null;
            }
            if (this.jobStartThread != null && !this.jobStartThread.isAlive()) {
                this.jobStartThread = null;
            }
            if (this.stufferThread != null && !this.stufferThread.isAlive()) {
                this.stufferThread = null;
            }
            if (this.expireStufferThread != null && !this.expireStufferThread.isAlive()) {
                this.expireStufferThread = null;
            }
            if (this.finisherThread != null && !this.finisherThread.isAlive()) {
                this.finisherThread = null;
            }
            if (this.notificationThread != null && !this.notificationThread.isAlive()) {
                this.notificationThread = null;
            }
            if (this.workerThreads != null) {
                boolean isAlive = false;
                for (int i3 = 0; i3 < this.workerThreads.length; ++i3) {
                    WorkerThread workerThread = this.workerThreads[i3];
                    if (workerThread == null) continue;
                    if (!workerThread.isAlive()) {
                        this.workerThreads[i3] = null;
                        continue;
                    }
                    isAlive = true;
                }
                if (!isAlive) {
                    this.workerThreads = null;
                }
            }
            if (this.expireThreads != null) {
                boolean isAlive = false;
                for (int i4 = 0; i4 < this.expireThreads.length; ++i4) {
                    ExpireThread expireThread = this.expireThreads[i4];
                    if (expireThread == null) continue;
                    if (!expireThread.isAlive()) {
                        this.expireThreads[i4] = null;
                        continue;
                    }
                    isAlive = true;
                }
                if (!isAlive) {
                    this.expireThreads = null;
                }
            }
            if (this.cleanupStufferThread != null && !this.cleanupStufferThread.isAlive()) {
                this.cleanupStufferThread = null;
            }
            if (this.cleanupThreads != null) {
                boolean isAlive = false;
                for (int i5 = 0; i5 < this.cleanupThreads.length; ++i5) {
                    DocumentCleanupThread cleanupThread = this.cleanupThreads[i5];
                    if (cleanupThread == null) continue;
                    if (!cleanupThread.isAlive()) {
                        this.cleanupThreads[i5] = null;
                        continue;
                    }
                    isAlive = true;
                }
                if (!isAlive) {
                    this.cleanupThreads = null;
                }
            }
            if (this.deleteStufferThread != null && !this.deleteStufferThread.isAlive()) {
                this.deleteStufferThread = null;
            }
            if (this.deleteThreads != null) {
                boolean isAlive = false;
                for (int i6 = 0; i6 < this.deleteThreads.length; ++i6) {
                    DocumentDeleteThread deleteThread = this.deleteThreads[i6];
                    if (deleteThread == null) continue;
                    if (!deleteThread.isAlive()) {
                        this.deleteThreads[i6] = null;
                        continue;
                    }
                    isAlive = true;
                }
                if (!isAlive) {
                    this.deleteThreads = null;
                }
            }
            if (this.jobResetThread != null && !this.jobResetThread.isAlive()) {
                this.jobResetThread = null;
            }
            if (this.seedingThread != null && !this.seedingThread.isAlive()) {
                this.seedingThread = null;
            }
            if (this.idleCleanupThread != null && !this.idleCleanupThread.isAlive()) {
                this.idleCleanupThread = null;
            }
            if (this.assessmentThread == null || this.assessmentThread.isAlive()) continue;
            this.assessmentThread = null;
        }
        RepositoryConnectorPoolFactory.make(threadContext).flushUnusedConnectors();
        NotificationConnectorPoolFactory.make(threadContext).flushUnusedConnectors();
        this.numWorkerThreads = 0;
        this.numDeleteThreads = 0;
        this.numExpireThreads = 0;
        Logging.root.info((Object)"Pull-agent successfully shut down");
    }
}

