/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.transport.TransportRequest;

public class InternalScrollSearchRequest
extends TransportRequest {
    private long id;
    private Scroll scroll;

    public InternalScrollSearchRequest() {
    }

    public InternalScrollSearchRequest(SearchScrollRequest request, long id) {
        super(request);
        this.id = id;
        this.scroll = request.scroll();
    }

    public InternalScrollSearchRequest(long id) {
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public InternalScrollSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
    }
}

