/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.NativeScriptEngineService;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.mvel.MvelScriptEngineService;

public class ScriptModule
extends AbstractModule {
    private final Settings settings;
    private final List<Class<? extends ScriptEngineService>> scriptEngines = Lists.newArrayList();
    private final Map<String, Class<? extends NativeScriptFactory>> scripts = Maps.newHashMap();

    public ScriptModule(Settings settings) {
        this.settings = settings;
    }

    public void addScriptEngine(Class<? extends ScriptEngineService> scriptEngine) {
        this.scriptEngines.add(scriptEngine);
    }

    public void registerScript(String name, Class<? extends NativeScriptFactory> script) {
        this.scripts.put(name, script);
    }

    @Override
    protected void configure() {
        MapBinder<String, NativeScriptFactory> scriptsBinder = MapBinder.newMapBinder(this.binder(), String.class, NativeScriptFactory.class);
        for (Map.Entry<String, Class<? extends NativeScriptFactory>> entry : this.scripts.entrySet()) {
            scriptsBinder.addBinding(entry.getKey()).to(entry.getValue());
        }
        Map<String, Settings> nativeSettings = this.settings.getGroups("script.native");
        for (Map.Entry<String, Settings> entry : nativeSettings.entrySet()) {
            String name = entry.getKey();
            Class<NativeScriptFactory> type = entry.getValue().getAsClass("type", NativeScriptFactory.class);
            if (type == NativeScriptFactory.class) {
                throw new ElasticsearchIllegalArgumentException("type is missing for native script [" + name + "]");
            }
            scriptsBinder.addBinding(name).to(type);
        }
        Multibinder<ScriptEngineService> multibinder = Multibinder.newSetBinder(this.binder(), ScriptEngineService.class);
        multibinder.addBinding().to(NativeScriptEngineService.class);
        try {
            multibinder.addBinding().to(MvelScriptEngineService.class);
        }
        catch (Throwable t) {
            // empty catch block
        }
        for (Class<? extends ScriptEngineService> scriptEngine : this.scriptEngines) {
            multibinder.addBinding().to(scriptEngine);
        }
        this.bind(ScriptService.class).asEagerSingleton();
    }
}

