/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter;

import org.apache.lucene.search.DocIdSet;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.cache.filter.FilterCacheStats;
import org.elasticsearch.index.cache.filter.weighted.WeightedFilterCache;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardFilterCache
extends AbstractIndexShardComponent
implements RemovalListener<WeightedFilterCache.FilterCacheKey, DocIdSet> {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();

    @Inject
    public ShardFilterCache(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public FilterCacheStats stats() {
        return new FilterCacheStats(this.totalMetric.count(), this.evictionsMetric.count());
    }

    public void onCached(long sizeInBytes) {
        this.totalMetric.inc(sizeInBytes);
    }

    @Override
    public void onRemoval(RemovalNotification<WeightedFilterCache.FilterCacheKey, DocIdSet> removalNotification) {
        if (removalNotification.wasEvicted()) {
            this.evictionsMetric.inc();
        }
        if (removalNotification.getValue() != null) {
            this.totalMetric.dec(DocIdSets.sizeInBytes(removalNotification.getValue()));
        }
    }
}

