/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class DeleteByQueryResponse
extends ActionResponse
implements Iterable<IndexDeleteByQueryResponse> {
    private Map<String, IndexDeleteByQueryResponse> indices = Maps.newHashMap();

    DeleteByQueryResponse() {
    }

    @Override
    public Iterator<IndexDeleteByQueryResponse> iterator() {
        return this.indices.values().iterator();
    }

    public Map<String, IndexDeleteByQueryResponse> getIndices() {
        return this.indices;
    }

    public IndexDeleteByQueryResponse getIndex(String index) {
        return this.indices.get(index);
    }

    public RestStatus status() {
        RestStatus status = RestStatus.OK;
        for (IndexDeleteByQueryResponse indexResponse : this.indices.values()) {
            if (indexResponse.getFailedShards() <= 0) continue;
            RestStatus indexStatus = indexResponse.getFailures()[0].status();
            if (indexResponse.getFailures().length > 1) {
                for (int i = 1; i < indexResponse.getFailures().length; ++i) {
                    if (indexResponse.getFailures()[i].status().getStatus() < 500) continue;
                    indexStatus = indexResponse.getFailures()[i].status();
                }
            }
            if (status.getStatus() >= indexStatus.getStatus()) continue;
            status = indexStatus;
        }
        return status;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            IndexDeleteByQueryResponse response = new IndexDeleteByQueryResponse();
            response.readFrom(in);
            this.indices.put(response.getIndex(), response);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indices.size());
        for (IndexDeleteByQueryResponse indexResponse : this.indices.values()) {
            indexResponse.writeTo(out);
        }
    }
}

