/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.ui.beans;

import java.util.Date;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class APIProfile
implements HttpSessionBindingListener {
    public static final String _rcsid = "@(#)$Id: APIProfile.java 1670616 2015-04-01 11:06:03Z kwright $";
    private long loginTime = -1L;
    private String userID = null;
    private boolean isLoggedIn = false;
    private String sessionIdentifier = null;

    public String session() {
        return this.sessionIdentifier;
    }

    public String getUserID() {
        return this.userID;
    }

    public void logout() {
        this.sessionCleanup();
    }

    public void login(IThreadContext threadContext, String userID, String userPassword) {
        this.sessionCleanup();
        try {
            if (ManifoldCF.verifyAPILogin((IThreadContext)threadContext, (String)userID, (String)userPassword)) {
                this.isLoggedIn = true;
                this.loginTime = System.currentTimeMillis();
                this.userID = userID;
            }
        }
        catch (ManifoldCFException e) {
            Logging.misc.fatal((Object)("Exception logging in: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean getLoggedOn() {
        return this.isLoggedIn;
    }

    public String getLoginTime() {
        return new Date(this.loginTime).toString();
    }

    public long getLoginTimeLong() {
        return this.loginTime;
    }

    private void sessionCleanup() {
        this.isLoggedIn = false;
        this.userID = null;
        this.loginTime = -1L;
    }

    public void valueBound(HttpSessionBindingEvent e) {
        HttpSession ss = e.getSession();
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = ss.getId();
        }
    }

    public void valueUnbound(HttpSessionBindingEvent e) {
        this.sessionCleanup();
        this.sessionIdentifier = null;
    }
}

