/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.IndexSizeTrigger;
import org.apache.solr.cloud.autoscaling.MetricTrigger;
import org.apache.solr.cloud.autoscaling.NodeAddedTrigger;
import org.apache.solr.cloud.autoscaling.NodeLostTrigger;
import org.apache.solr.cloud.autoscaling.ScheduledTrigger;
import org.apache.solr.cloud.autoscaling.SearchRateTrigger;
import org.apache.solr.cloud.autoscaling.TriggerAction;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrResourceLoader;

public class AutoScaling {
    public static final String AUTO_ADD_REPLICAS_TRIGGER_NAME = ".auto_add_replicas";
    public static final String AUTO_ADD_REPLICAS_TRIGGER_DSL = "    {        'name' : '.auto_add_replicas',        'event' : 'nodeLost',        'waitFor' : -1,        'enabled' : true,        'actions' : [            {                'name':'auto_add_replicas_plan',                'class':'solr.AutoAddReplicasPlanAction'            },            {                'name':'execute_plan',                'class':'solr.ExecutePlanAction'            }        ]    }";
    public static final Map<String, Object> AUTO_ADD_REPLICAS_TRIGGER_PROPS = (Map)Utils.fromJSONString((String)"    {        'name' : '.auto_add_replicas',        'event' : 'nodeLost',        'waitFor' : -1,        'enabled' : true,        'actions' : [            {                'name':'auto_add_replicas_plan',                'class':'solr.AutoAddReplicasPlanAction'            },            {                'name':'execute_plan',                'class':'solr.ExecutePlanAction'            }        ]    }");
    public static final String SCHEDULED_MAINTENANCE_TRIGGER_NAME = ".scheduled_maintenance";
    public static final String SCHEDULED_MAINTENANCE_TRIGGER_DSL = "    {        'name' : '.scheduled_maintenance',        'event' : 'scheduled',        'startTime' : 'NOW',        'every' : '+1DAY',        'enabled' : true,        'actions' : [            {                'name':'inactive_shard_plan',                'class':'solr.InactiveShardPlanAction'            },            {                'name':'inactive_markers_plan',                'class':'solr.InactiveMarkersPlanAction'            },            {                'name':'execute_plan',                'class':'solr.ExecutePlanAction'            }        ]    }";
    public static final Map<String, Object> SCHEDULED_MAINTENANCE_TRIGGER_PROPS = (Map)Utils.fromJSONString((String)"    {        'name' : '.scheduled_maintenance',        'event' : 'scheduled',        'startTime' : 'NOW',        'every' : '+1DAY',        'enabled' : true,        'actions' : [            {                'name':'inactive_shard_plan',                'class':'solr.InactiveShardPlanAction'            },            {                'name':'inactive_markers_plan',                'class':'solr.InactiveMarkersPlanAction'            },            {                'name':'execute_plan',                'class':'solr.ExecutePlanAction'            }        ]    }");

    public static class TriggerFactoryImpl
    extends TriggerFactory {
        private final SolrCloudManager cloudManager;
        private final SolrResourceLoader loader;

        public TriggerFactoryImpl(SolrResourceLoader loader, SolrCloudManager cloudManager) {
            Objects.requireNonNull(cloudManager);
            Objects.requireNonNull(loader);
            this.cloudManager = cloudManager;
            this.loader = loader;
        }

        @Override
        public synchronized Trigger create(TriggerEventType type, String name, Map<String, Object> props) throws TriggerValidationException {
            TriggerBase t;
            if (this.isClosed) {
                throw new AlreadyClosedException("TriggerFactory has already been closed, cannot create new triggers");
            }
            if (type == null) {
                throw new IllegalArgumentException("Trigger type must not be null");
            }
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Trigger name must not be empty");
            }
            switch (type) {
                case NODEADDED: {
                    t = new NodeAddedTrigger(name);
                    break;
                }
                case NODELOST: {
                    t = new NodeLostTrigger(name);
                    break;
                }
                case SEARCHRATE: {
                    t = new SearchRateTrigger(name);
                    break;
                }
                case METRIC: {
                    t = new MetricTrigger(name);
                    break;
                }
                case SCHEDULED: {
                    t = new ScheduledTrigger(name);
                    break;
                }
                case INDEXSIZE: {
                    t = new IndexSizeTrigger(name);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown event type: " + type + " in trigger: " + name);
                }
            }
            t.configure(this.loader, this.cloudManager, props);
            return t;
        }
    }

    public static abstract class TriggerFactory
    implements Closeable {
        protected boolean isClosed = false;

        public abstract Trigger create(TriggerEventType var1, String var2, Map<String, Object> var3) throws TriggerValidationException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            TriggerFactory triggerFactory = this;
            synchronized (triggerFactory) {
                this.isClosed = true;
            }
        }
    }

    public static interface Trigger
    extends Closeable,
    Runnable {
        public String getName();

        public TriggerEventType getEventType();

        public boolean isEnabled();

        public Map<String, Object> getProperties();

        public int getWaitForSecond();

        public List<TriggerAction> getActions();

        public void setProcessor(TriggerEventProcessor var1);

        public TriggerEventProcessor getProcessor();

        public boolean isClosed();

        public void restoreState(Trigger var1);

        public void saveState();

        public void restoreState();

        public void configure(SolrResourceLoader var1, SolrCloudManager var2, Map<String, Object> var3) throws TriggerValidationException;

        public void init() throws Exception;
    }

    public static interface TriggerEventProcessor {
        public boolean process(TriggerEvent var1);
    }
}

