/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.Bits;

public class BitsFilteredPostingsEnum
extends FilterLeafReader.FilterPostingsEnum {
    private final Bits acceptDocs;

    public static PostingsEnum wrap(PostingsEnum in, Bits acceptDocs) {
        if (in == null || acceptDocs == null) {
            return in;
        }
        return new BitsFilteredPostingsEnum(in, acceptDocs);
    }

    private BitsFilteredPostingsEnum(PostingsEnum in, Bits acceptDocs) {
        super(in);
        this.acceptDocs = acceptDocs;
    }

    private int doNext(int doc) throws IOException {
        while (doc != Integer.MAX_VALUE && !this.acceptDocs.get(doc)) {
            doc = super.nextDoc();
        }
        return doc;
    }

    public int nextDoc() throws IOException {
        return this.doNext(super.nextDoc());
    }

    public int advance(int target) throws IOException {
        return this.doNext(super.advance(target));
    }
}

