/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.crypto.encryption;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.directory.api.util.Strings;

public class DesStringToKey {
    public byte[] getKey(String passPhrase) {
        return this.generateKey(passPhrase);
    }

    public byte[] getKey(String password, String realmName, String userName) {
        return this.generateKey(password + realmName + userName);
    }

    protected byte[] generateKey(String passPhrase) {
        byte[] encodedByteArray = this.characterEncodeString(passPhrase);
        byte[] paddedByteArray = this.padString(encodedByteArray);
        byte[] secretKey = this.fanFold(paddedByteArray);
        secretKey = this.setParity(secretKey);
        secretKey = this.getStrongKey(secretKey);
        secretKey = this.calculateChecksum(paddedByteArray, secretKey);
        secretKey = this.setParity(secretKey);
        secretKey = this.getStrongKey(secretKey);
        return secretKey;
    }

    protected byte[] setParity(byte[] in) {
        byte[] out = new byte[8];
        int bitCount = 0;
        int index = 0;
        for (int i = 0; i < 64; ++i) {
            boolean bit;
            if ((i + 1) % 8 == 0) {
                if (bitCount % 2 == 0) {
                    this.setBit(out, i, 1);
                }
                ++index;
                bitCount = 0;
                continue;
            }
            int val = this.getBit(in, index);
            boolean bl = bit = val > 0;
            if (bit) {
                this.setBit(out, i, val);
                ++bitCount;
            }
            ++index;
        }
        return out;
    }

    protected int getBit(byte[] data, int pos) {
        int posByte = pos / 8;
        int posBit = pos % 8;
        byte valByte = data[posByte];
        return valByte >> 8 - (posBit + 1) & 1;
    }

    protected void setBit(byte[] data, int pos, int val) {
        byte newByte;
        int posByte = pos / 8;
        int posBit = pos % 8;
        byte oldByte = data[posByte];
        oldByte = (byte)(65407 >> posBit & oldByte & 0xFF);
        data[posByte] = newByte = (byte)(val << 8 - (posBit + 1) | oldByte);
    }

    protected byte[] fanFold(byte[] paddedByteArray) {
        byte[] secretKey = new byte[8];
        int div = paddedByteArray.length / 8;
        for (int ii = 0; ii < div; ++ii) {
            int jj;
            byte[] blockValue1 = new byte[8];
            System.arraycopy(paddedByteArray, ii * 8, blockValue1, 0, 8);
            if (ii % 2 == 1) {
                int jj2;
                byte tempbyte1 = 0;
                byte tempbyte2 = 0;
                byte[] blockValue2 = new byte[8];
                for (jj2 = 0; jj2 < 8; ++jj2) {
                    int kk;
                    for (kk = 0; kk < 4; ++kk) {
                        tempbyte2 = (byte)(1 << 7 - kk & 0xFF);
                        tempbyte1 = (byte)(tempbyte1 | (blockValue1[jj2] & tempbyte2) >>> 7 - 2 * kk);
                    }
                    for (kk = 4; kk < 8; ++kk) {
                        tempbyte2 = (byte)(1 << 7 - kk & 0xFF);
                        tempbyte1 = (byte)(tempbyte1 | (blockValue1[jj2] & tempbyte2) << 2 * kk - 7);
                    }
                    blockValue2[7 - jj2] = tempbyte1;
                    tempbyte1 = 0;
                }
                for (jj2 = 0; jj2 < 8; ++jj2) {
                    blockValue2[jj2] = (byte)((blockValue2[jj2] & 0xFF) >>> 1 & 0xFF);
                }
                System.arraycopy(blockValue2, 0, blockValue1, 0, blockValue2.length);
            }
            for (jj = 0; jj < 8; ++jj) {
                blockValue1[jj] = (byte)((blockValue1[jj] & 0xFF) << 1 & 0xFF);
            }
            for (jj = 0; jj < 8; ++jj) {
                int n = jj;
                secretKey[n] = (byte)(secretKey[n] ^ blockValue1[jj]);
            }
        }
        return secretKey;
    }

    protected byte[] calculateChecksum(byte[] data, byte[] keyBytes) {
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
            IvParameterSpec paramSpec = new IvParameterSpec(keyBytes);
            cipher.init(1, (Key)key, paramSpec);
            byte[] result = cipher.doFinal(data);
            byte[] checksum = new byte[8];
            System.arraycopy(result, result.length - 8, checksum, 0, 8);
            return checksum;
        }
        catch (GeneralSecurityException nsae) {
            nsae.printStackTrace();
            return null;
        }
    }

    protected byte[] getStrongKey(byte[] secretKey) {
        try {
            if (DESKeySpec.isWeak(secretKey, 0)) {
                secretKey[7] = (byte)(secretKey[7] ^ 0xF0);
            }
        }
        catch (InvalidKeyException ike) {
            return new byte[8];
        }
        return secretKey;
    }

    protected byte[] characterEncodeString(String string) {
        return Strings.getBytesUtf8((String)string);
    }

    protected byte[] padString(byte[] encodedString) {
        int length = encodedString.length < 8 ? encodedString.length : encodedString.length % 8;
        if (length == 0) {
            return encodedString;
        }
        byte[] paddedByteArray = new byte[8 - length + encodedString.length];
        for (int ii = paddedByteArray.length - 1; ii > encodedString.length - 1; --ii) {
            paddedByteArray[ii] = 0;
        }
        System.arraycopy(encodedString, 0, paddedByteArray, 0, encodedString.length);
        return paddedByteArray;
    }
}

