/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hadoopauth.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.hadoopauth.filter.HadoopAuthFilter;
import org.apache.knox.gateway.hadoopauth.filter.HadoopAuthPostFilter;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class HadoopAuthDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String HADOOPAUTH_FILTER_CLASSNAME = HadoopAuthFilter.class.getCanonicalName();
    private static final String HADOOPAUTH_POSTFILTER_CLASSNAME = HadoopAuthPostFilter.class.getCanonicalName();
    public static final String ROLE = "authentication";
    public static final String NAME = "HadoopAuth";

    public String getRole() {
        return ROLE;
    }

    public String getName() {
        return NAME;
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        if (params == null) {
            params = new ArrayList<FilterParamDescriptor>();
        }
        Map providerParams = provider.getParams();
        for (Map.Entry entry : providerParams.entrySet()) {
            String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            params.add(resource.createFilterParam().name(key).value((String)entry.getValue()));
        }
        String clusterName = context.getTopology().getName();
        params.add(resource.createFilterParam().name("clusterName").value(clusterName));
        resource.addFilter().name(this.getName()).role(this.getRole()).impl(HADOOPAUTH_FILTER_CLASSNAME).params(params);
        resource.addFilter().name("Post" + this.getName()).role(this.getRole()).impl(HADOOPAUTH_POSTFILTER_CLASSNAME).params(params);
    }
}

