/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiCreateEnvironment;
import com.cloudera.api.swagger.model.ApiRemoteDataContext;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CdpResourceApi {
    private ApiClient apiClient;

    public CdpResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CdpResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createEnvironmentCommandCall(String serviceName, ApiCreateEnvironment body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiCreateEnvironment localVarPostBody = body;
        String localVarPath = "/cdp/createEnvironment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (serviceName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "serviceName", serviceName));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createEnvironmentCommandValidateBeforeCall(String serviceName, ApiCreateEnvironment body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.createEnvironmentCommandCall(serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand createEnvironmentCommand(String serviceName, ApiCreateEnvironment body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.createEnvironmentCommandWithHttpInfo(serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> createEnvironmentCommandWithHttpInfo(String serviceName, ApiCreateEnvironment body) throws ApiException {
        Call call = this.createEnvironmentCommandValidateBeforeCall(serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createEnvironmentCommandAsync(String serviceName, ApiCreateEnvironment body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createEnvironmentCommandValidateBeforeCall(serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getRemoteContextCall(String dataContextName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cdp/remoteContext/byContext/{dataContextName}".replaceAll("\\{dataContextName\\}", this.apiClient.escapeString(dataContextName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRemoteContextValidateBeforeCall(String dataContextName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (dataContextName == null) {
            throw new ApiException("Missing the required parameter 'dataContextName' when calling getRemoteContext(Async)");
        }
        Call call = this.getRemoteContextCall(dataContextName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRemoteDataContext getRemoteContext(String dataContextName) throws ApiException {
        ApiResponse<ApiRemoteDataContext> resp = this.getRemoteContextWithHttpInfo(dataContextName);
        return resp.getData();
    }

    public ApiResponse<ApiRemoteDataContext> getRemoteContextWithHttpInfo(String dataContextName) throws ApiException {
        Call call = this.getRemoteContextValidateBeforeCall(dataContextName, null, null);
        Type localVarReturnType = new TypeToken<ApiRemoteDataContext>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRemoteContextAsync(String dataContextName, final ApiCallback<ApiRemoteDataContext> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRemoteContextValidateBeforeCall(dataContextName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRemoteDataContext>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getRemoteContextByClusterCall(String clusterName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/cdp/remoteContext/byCluster/{clusterName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRemoteContextByClusterValidateBeforeCall(String clusterName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling getRemoteContextByCluster(Async)");
        }
        Call call = this.getRemoteContextByClusterCall(clusterName, progressListener, progressRequestListener);
        return call;
    }

    public ApiRemoteDataContext getRemoteContextByCluster(String clusterName) throws ApiException {
        ApiResponse<ApiRemoteDataContext> resp = this.getRemoteContextByClusterWithHttpInfo(clusterName);
        return resp.getData();
    }

    public ApiResponse<ApiRemoteDataContext> getRemoteContextByClusterWithHttpInfo(String clusterName) throws ApiException {
        Call call = this.getRemoteContextByClusterValidateBeforeCall(clusterName, null, null);
        Type localVarReturnType = new TypeToken<ApiRemoteDataContext>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRemoteContextByClusterAsync(String clusterName, final ApiCallback<ApiRemoteDataContext> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRemoteContextByClusterValidateBeforeCall(clusterName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRemoteDataContext>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postRemoteContextCall(ApiRemoteDataContext body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiRemoteDataContext localVarPostBody = body;
        String localVarPath = "/cdp/remoteContext";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postRemoteContextValidateBeforeCall(ApiRemoteDataContext body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.postRemoteContextCall(body, progressListener, progressRequestListener);
        return call;
    }

    public ApiRemoteDataContext postRemoteContext(ApiRemoteDataContext body) throws ApiException {
        ApiResponse<ApiRemoteDataContext> resp = this.postRemoteContextWithHttpInfo(body);
        return resp.getData();
    }

    public ApiResponse<ApiRemoteDataContext> postRemoteContextWithHttpInfo(ApiRemoteDataContext body) throws ApiException {
        Call call = this.postRemoteContextValidateBeforeCall(body, null, null);
        Type localVarReturnType = new TypeToken<ApiRemoteDataContext>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postRemoteContextAsync(ApiRemoteDataContext body, final ApiCallback<ApiRemoteDataContext> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postRemoteContextValidateBeforeCall(body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiRemoteDataContext>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

