/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.jdbc.MysqlDataSource;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.hsqldb.jdbc.JDBCDataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.jdbc.SslMode;
import org.postgresql.ssl.NonValidatingFactory;

public class JDBCUtils {
    public static final String POSTGRESQL_DB_TYPE = "postgresql";
    public static final String MYSQL_DB_TYPE = "mysql";
    public static final String DERBY_DB_TYPE = "derbydb";
    public static final String HSQL = "hsql";
    public static final String DATABASE_USER_ALIAS_NAME = "gateway_database_user";
    public static final String DATABASE_PASSWORD_ALIAS_NAME = "gateway_database_password";
    public static final String DATABASE_TRUSTSTORE_PASSWORD_ALIAS_NAME = "gateway_database_ssl_truststore_password";

    public static DataSource getDataSource(GatewayConfig gatewayConfig, AliasService aliasService) throws AliasServiceException, SQLException {
        if (POSTGRESQL_DB_TYPE.equalsIgnoreCase(gatewayConfig.getDatabaseType())) {
            return JDBCUtils.createPostgresDataSource(gatewayConfig, aliasService);
        }
        if (DERBY_DB_TYPE.equalsIgnoreCase(gatewayConfig.getDatabaseType())) {
            return JDBCUtils.createDerbyDatasource(gatewayConfig, aliasService);
        }
        if (HSQL.equalsIgnoreCase(gatewayConfig.getDatabaseType())) {
            return JDBCUtils.createHsqlDatasource(gatewayConfig, aliasService);
        }
        if (MYSQL_DB_TYPE.equalsIgnoreCase(gatewayConfig.getDatabaseType())) {
            return JDBCUtils.createMySqlDataSource(gatewayConfig, aliasService);
        }
        throw new IllegalArgumentException("Invalid database type: " + gatewayConfig.getDatabaseType());
    }

    private static DataSource createPostgresDataSource(GatewayConfig gatewayConfig, AliasService aliasService) throws AliasServiceException {
        PGSimpleDataSource postgresDataSource = new PGSimpleDataSource();
        String dbUser = JDBCUtils.getDatabaseUser(aliasService);
        String dbPassword = JDBCUtils.getDatabasePassword(aliasService);
        if (gatewayConfig.getDatabaseConnectionUrl() != null) {
            postgresDataSource.setUrl(gatewayConfig.getDatabaseConnectionUrl());
            if (StringUtils.isNotBlank((CharSequence)dbUser)) {
                postgresDataSource.setUser(dbUser);
            }
            if (StringUtils.isNotBlank((CharSequence)dbPassword)) {
                postgresDataSource.setPassword(dbPassword);
            }
        } else {
            postgresDataSource.setDatabaseName(gatewayConfig.getDatabaseName());
            postgresDataSource.setServerNames(new String[]{gatewayConfig.getDatabaseHost()});
            postgresDataSource.setPortNumbers(new int[]{gatewayConfig.getDatabasePort()});
            postgresDataSource.setUser(dbUser);
            postgresDataSource.setPassword(dbPassword);
        }
        JDBCUtils.configurePostgreSQLSsl(gatewayConfig, aliasService, postgresDataSource);
        return postgresDataSource;
    }

    private static void configurePostgreSQLSsl(GatewayConfig gatewayConfig, AliasService aliasService, PGSimpleDataSource postgresDataSource) throws AliasServiceException {
        if (gatewayConfig.isDatabaseSslEnabled()) {
            postgresDataSource.setSsl(true);
            postgresDataSource.setSslMode(SslMode.VERIFY_FULL.value);
            if (gatewayConfig.verifyDatabaseSslServerCertificate()) {
                postgresDataSource.setSslRootCert(gatewayConfig.getDatabaseSslTruststoreFileName());
                postgresDataSource.setSslPassword(JDBCUtils.getDatabaseAlias(aliasService, DATABASE_TRUSTSTORE_PASSWORD_ALIAS_NAME));
            } else {
                postgresDataSource.setSslfactory(NonValidatingFactory.class.getCanonicalName());
            }
        }
    }

    private static DataSource createDerbyDatasource(GatewayConfig gatewayConfig, AliasService aliasService) throws AliasServiceException {
        ClientDataSource derbyDatasource = new ClientDataSource();
        derbyDatasource.setDatabaseName(gatewayConfig.getDatabaseName());
        derbyDatasource.setServerName(gatewayConfig.getDatabaseHost());
        derbyDatasource.setPortNumber(gatewayConfig.getDatabasePort());
        derbyDatasource.setUser(JDBCUtils.getDatabaseUser(aliasService));
        derbyDatasource.setPassword(JDBCUtils.getDatabasePassword(aliasService));
        return derbyDatasource;
    }

    private static DataSource createHsqlDatasource(GatewayConfig gatewayConfig, AliasService aliasService) throws AliasServiceException {
        JDBCDataSource hsqlDatasource = new JDBCDataSource();
        hsqlDatasource.setUrl(gatewayConfig.getDatabaseConnectionUrl());
        hsqlDatasource.setUser(JDBCUtils.getDatabaseUser(aliasService));
        hsqlDatasource.setPassword(JDBCUtils.getDatabasePassword(aliasService));
        return hsqlDatasource;
    }

    private static DataSource createMySqlDataSource(GatewayConfig gatewayConfig, AliasService aliasService) throws AliasServiceException, SQLException {
        MysqlDataSource dataSource = new MysqlDataSource();
        if (gatewayConfig.getDatabaseConnectionUrl() != null) {
            dataSource.setUrl(gatewayConfig.getDatabaseConnectionUrl());
        } else {
            dataSource.setDatabaseName(gatewayConfig.getDatabaseName());
            dataSource.setServerName(gatewayConfig.getDatabaseHost());
            dataSource.setPortNumber(gatewayConfig.getDatabasePort());
            dataSource.setUser(JDBCUtils.getDatabaseUser(aliasService));
            dataSource.setPassword(JDBCUtils.getDatabasePassword(aliasService));
            JDBCUtils.configureMysqlSsl(gatewayConfig, aliasService, dataSource);
        }
        return dataSource;
    }

    private static void configureMysqlSsl(GatewayConfig gatewayConfig, AliasService aliasService, MysqlDataSource dataSource) throws AliasServiceException, SQLException {
        if (gatewayConfig.isDatabaseSslEnabled()) {
            dataSource.setUseSSL(true);
            if (gatewayConfig.verifyDatabaseSslServerCertificate()) {
                dataSource.setSslMode(PropertyDefinitions.SslMode.VERIFY_CA.name());
                dataSource.setVerifyServerCertificate(true);
                dataSource.setTrustCertificateKeyStoreType("JKS");
                dataSource.setTrustCertificateKeyStoreUrl("file:" + gatewayConfig.getDatabaseSslTruststoreFileName());
                dataSource.setTrustCertificateKeyStorePassword(JDBCUtils.getDatabaseAlias(aliasService, DATABASE_TRUSTSTORE_PASSWORD_ALIAS_NAME));
            } else {
                dataSource.setVerifyServerCertificate(false);
            }
        }
    }

    private static String getDatabaseUser(AliasService aliasService) throws AliasServiceException {
        return JDBCUtils.getDatabaseAlias(aliasService, DATABASE_USER_ALIAS_NAME);
    }

    private static String getDatabasePassword(AliasService aliasService) throws AliasServiceException {
        return JDBCUtils.getDatabaseAlias(aliasService, DATABASE_PASSWORD_ALIAS_NAME);
    }

    private static String getDatabaseAlias(AliasService aliasService, String aliasName) throws AliasServiceException {
        char[] value = aliasService.getPasswordFromAliasForGateway(aliasName);
        return value == null ? null : new String(value);
    }

    public static boolean isTableExists(String tableName, DataSource dataSource) throws SQLException {
        boolean exists = false;
        try (Connection connection = dataSource.getConnection();){
            DatabaseMetaData dbMetadata = connection.getMetaData();
            String tableNameToCheck = dbMetadata.storesUpperCaseIdentifiers() ? tableName : tableName.toLowerCase(Locale.ROOT);
            try (ResultSet tables = dbMetadata.getTables(connection.getCatalog(), null, tableNameToCheck, null);){
                exists = tables.next();
            }
        }
        return exists;
    }

    public static void createTable(String createSqlFileName, DataSource dataSource, ClassLoader classLoader) throws Exception {
        InputStream is = classLoader.getResourceAsStream(createSqlFileName);
        String createTableSql = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        try (Connection connection = dataSource.getConnection();
             Statement createTableStatment = connection.createStatement();){
            createTableStatment.execute(createTableSql);
        }
    }
}

