/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.audit.log4j.appender;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.knox.gateway.audit.log4j.appender.JdbmQueue;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class JdbmStoreAndForwardAppender
extends AppenderSkeleton {
    private File file;
    private Thread forwarder;
    private JdbmQueue<LoggingEvent> queue;
    private Logger forward;
    private boolean fetchLocationInfo = true;

    public boolean requiresLayout() {
        return false;
    }

    public void setFile(String file) {
        this.file = new File(file);
    }

    public void setFetchLocationInfo(boolean fetchLocationInfo) {
        this.fetchLocationInfo = fetchLocationInfo;
    }

    public boolean isFetchLocationInfo() {
        return this.fetchLocationInfo;
    }

    public void activateOptions() {
        try {
            this.queue = new JdbmQueue(this.file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.forward = Logger.getLogger((String)"audit.forward");
        this.forward.setAdditivity(false);
        this.forwarder = new Forwarder();
        this.forwarder.setDaemon(true);
        this.forwarder.start();
    }

    protected void append(LoggingEvent event) {
        try {
            if (this.fetchLocationInfo) {
                event.getLocationInformation();
            }
            this.queue.enqueue(event);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.queue.stop();
            this.forwarder.join();
            this.queue.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class Forwarder
    extends Thread {
        private Forwarder() {
        }

        @Override
        public void run() {
            final AtomicBoolean done = new AtomicBoolean(false);
            while (!done.get()) {
                try {
                    JdbmStoreAndForwardAppender.this.queue.process(new JdbmQueue.Consumer<LoggingEvent>(){

                        @Override
                        public boolean consume(LoggingEvent event) {
                            try {
                                if (event == null) {
                                    done.set(true);
                                } else {
                                    JdbmStoreAndForwardAppender.this.forward.callAppenders(event);
                                }
                                return true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return false;
                            }
                        }
                    });
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

