/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.javascript;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.filter.rewrite.impl.javascript.JavaScriptFilterReader;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Resolver;
import org.apache.knox.gateway.util.urltemplate.Template;

public class JavaScriptUrlRewriteFilterReader
extends JavaScriptFilterReader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private Resolver resolver;
    private UrlRewriter rewriter;
    private UrlRewriter.Direction direction;

    public JavaScriptUrlRewriteFilterReader(Reader reader, UrlRewriter rewriter, Resolver resolver, UrlRewriter.Direction direction, UrlRewriteFilterContentDescriptor config) throws IOException {
        super(reader, config);
        this.resolver = resolver;
        this.rewriter = rewriter;
        this.direction = direction;
    }

    @Override
    public String filterValueString(String name, String value, String rule) {
        try {
            Template input = Parser.parseLiteral((String)value);
            Template output = this.rewriter.rewrite(this.resolver, input, this.direction, rule);
            if (output != null) {
                value = output.getPattern();
            }
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }
}

