/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.yarn;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;

public class SubmitApp {

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String text;
        private String file;

        Request(KnoxSession session) {
            super(session);
        }

        public Request text(String text) {
            this.text = text;
            return this;
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/resourcemanager", "/v1/cluster/apps"});
                    HttpPost request = new HttpPost(uri.build());
                    StringEntity entity = null;
                    if (text != null) {
                        entity = new StringEntity(text, ContentType.APPLICATION_JSON);
                    } else if (file != null) {
                        entity = new FileEntity(new File(file), ContentType.APPLICATION_JSON);
                    }
                    request.setEntity(entity);
                    return new Response((HttpResponse)this.execute((HttpRequest)request));
                }
            };
        }
    }
}

