/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl.state;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.token.impl.TokenStateServiceMessages;
import org.apache.knox.gateway.services.token.state.JournalEntry;
import org.apache.knox.gateway.services.token.state.TokenStateJournal;

abstract class FileTokenStateJournal
implements TokenStateJournal {
    protected static final int INDEX_TOKEN_ID = 0;
    protected static final int INDEX_ISSUE_TIME = 1;
    protected static final int INDEX_EXPIRATION = 2;
    protected static final int INDEX_MAX_LIFETIME = 3;
    protected static final TokenStateServiceMessages log = (TokenStateServiceMessages)MessagesFactory.get(TokenStateServiceMessages.class);
    protected static final String JOURNAL_DIR_NAME = "token-state";
    protected final Path journalDir;

    protected FileTokenStateJournal(GatewayConfig config) throws IOException {
        this.journalDir = Paths.get(config.getGatewaySecurityDir(), JOURNAL_DIR_NAME);
        if (!Files.exists(this.journalDir, new LinkOption[0])) {
            Files.createDirectories(this.journalDir, new FileAttribute[0]);
        }
    }

    @Override
    public abstract void add(String var1, long var2, long var4, long var6) throws IOException;

    @Override
    public void add(JournalEntry entry) throws IOException {
        this.add(Collections.singletonList(entry));
    }

    @Override
    public abstract void add(List<JournalEntry> var1) throws IOException;

    @Override
    public List<JournalEntry> get() throws IOException {
        return this.loadJournal();
    }

    @Override
    public abstract JournalEntry get(String var1) throws IOException;

    @Override
    public void remove(String tokenId) throws IOException {
        this.remove(Collections.singleton(tokenId));
    }

    @Override
    public abstract void remove(Collection<String> var1) throws IOException;

    @Override
    public void remove(JournalEntry entry) throws IOException {
        this.remove(entry.getTokenId());
    }

    protected abstract List<JournalEntry> loadJournal() throws IOException;

    protected List<FileJournalEntry> loadJournal(FileChannel channel) throws IOException {
        ArrayList<FileJournalEntry> entries = new ArrayList<FileJournalEntry>();
        try (InputStream input = Channels.newInputStream(channel);){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                try {
                    entries.add(FileJournalEntry.parse(line));
                }
                catch (Exception e) {
                    log.failedToLoadJournalEntry(e);
                }
            }
        }
        return entries;
    }

    protected FileJournalEntry parse(String entry) {
        return FileJournalEntry.parse(entry);
    }

    static final class FileJournalEntry
    implements JournalEntry {
        private final String tokenId;
        private final String issueTime;
        private final String expiration;
        private final String maxLifetime;

        FileJournalEntry(String tokenId, long issueTime, long expiration, long maxLifetime) {
            this(tokenId, String.valueOf(issueTime), String.valueOf(expiration), String.valueOf(maxLifetime));
        }

        FileJournalEntry(String tokenId, String issueTime, String expiration, String maxLifetime) {
            this.tokenId = tokenId;
            this.issueTime = issueTime;
            this.expiration = expiration;
            this.maxLifetime = maxLifetime;
        }

        @Override
        public String getTokenId() {
            return this.tokenId;
        }

        @Override
        public String getIssueTime() {
            return this.issueTime;
        }

        @Override
        public String getExpiration() {
            return this.expiration;
        }

        @Override
        public String getMaxLifetime() {
            return this.maxLifetime;
        }

        public String toString() {
            String[] elements = new String[4];
            elements[0] = this.getTokenId();
            String issueTime = this.getIssueTime();
            elements[1] = issueTime != null ? issueTime : "";
            String expiration = this.getExpiration();
            elements[2] = expiration != null ? expiration : "";
            String maxLifetime = this.getMaxLifetime();
            elements[3] = maxLifetime != null ? maxLifetime : "";
            return String.format(Locale.ROOT, "%s,%s,%s,%s", elements[0], elements[1], elements[2], elements[3]);
        }

        static FileJournalEntry parse(String entry) {
            String[] elements = entry.split(",");
            if (elements.length < 4) {
                throw new IllegalArgumentException("Invalid journal entry: " + entry);
            }
            String tokenId = elements[0].trim();
            String issueTime = elements[1].trim();
            String expiration = elements[2].trim();
            String maxLifetime = elements[3].trim();
            return new FileJournalEntry(tokenId.isEmpty() ? null : tokenId, issueTime.isEmpty() ? null : issueTime, expiration.isEmpty() ? null : expiration, maxLifetime.isEmpty() ? null : maxLifetime);
        }
    }
}

