/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;

public class DefaultTokenAuthorityService
implements JWTokenAuthority,
Service {
    private static final GatewayResources RESOURCES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private static final Set<String> SUPPORTED_SIG_ALGS = new HashSet<String>();
    private AliasService aliasService;
    private KeystoreService keystoreService;
    private GatewayConfig config;
    private char[] cachedSigningKeyPassphrase;
    private RSAPrivateKey signingKey;

    public void setKeystoreService(KeystoreService ks) {
        this.keystoreService = ks;
    }

    public void setAliasService(AliasService as) {
        this.aliasService = as;
    }

    public JWT issueToken(Subject subject, String algorithm) throws TokenServiceException {
        Principal p = (Principal)subject.getPrincipals().toArray()[0];
        return this.issueToken(p, algorithm);
    }

    public JWT issueToken(Principal p, String algorithm) throws TokenServiceException {
        return this.issueToken(p, null, algorithm);
    }

    public JWT issueToken(Principal p, String algorithm, long expires) throws TokenServiceException {
        return this.issueToken(p, (String)null, algorithm, expires);
    }

    public JWT issueToken(Principal p, String audience, String algorithm) throws TokenServiceException {
        return this.issueToken(p, audience, algorithm, -1L);
    }

    public JWT issueToken(Principal p, String audience, String algorithm, long expires) throws TokenServiceException {
        ArrayList<String> audiences = null;
        if (audience != null) {
            audiences = new ArrayList<String>();
            audiences.add(audience);
        }
        return this.issueToken(p, audiences, algorithm, expires);
    }

    public JWT issueToken(Principal p, List<String> audiences, String algorithm, long expires) throws TokenServiceException {
        return this.issueToken(p, audiences, algorithm, expires, null, null, null);
    }

    private RSAPrivateKey getSigningKey(String signingKeystoreName, String signingKeystoreAlias, char[] signingKeystorePassphrase) throws KeystoreServiceException, TokenServiceException {
        if (signingKeystorePassphrase != null) {
            return (RSAPrivateKey)this.keystoreService.getSigningKey(signingKeystoreName, this.getSigningKeyAlias(signingKeystoreAlias), this.getSigningKeyPassphrase(signingKeystorePassphrase));
        }
        return this.signingKey;
    }

    public JWT issueToken(Principal p, List<String> audiences, String algorithm, long expires, String signingKeystoreName, String signingKeystoreAlias, char[] signingKeystorePassphrase) throws TokenServiceException {
        JWTToken token;
        String[] claimArray = new String[]{"KNOXSSO", p.getName(), null, expires == -1L ? null : String.valueOf(expires)};
        if (SUPPORTED_SIG_ALGS.contains(algorithm)) {
            token = new JWTToken(algorithm, claimArray, audiences);
            try {
                RSAPrivateKey key = this.getSigningKey(signingKeystoreName, signingKeystoreAlias, signingKeystorePassphrase);
                RSASSASigner signer = new RSASSASigner((PrivateKey)key, true);
                token.sign((JWSSigner)signer);
            }
            catch (KeystoreServiceException e) {
                throw new TokenServiceException((Exception)((Object)e));
            }
        } else {
            throw new TokenServiceException("Cannot issue token - Unsupported algorithm");
        }
        return token;
    }

    private char[] getSigningKeyPassphrase(char[] signingKeyPassphrase) {
        return signingKeyPassphrase != null ? signingKeyPassphrase : this.cachedSigningKeyPassphrase;
    }

    private String getSigningKeyAlias() {
        String alias = this.config.getSigningKeyAlias();
        return alias == null ? "gateway-identity" : alias;
    }

    private String getSigningKeyAlias(String signingKeystoreAlias) {
        if (signingKeystoreAlias != null) {
            return signingKeystoreAlias;
        }
        return this.getSigningKeyAlias();
    }

    public boolean verifyToken(JWT token) throws TokenServiceException {
        return this.verifyToken(token, null);
    }

    public boolean verifyToken(JWT token, RSAPublicKey publicKey) throws TokenServiceException {
        boolean rc;
        try {
            PublicKey key = publicKey == null ? this.keystoreService.getSigningKeystore().getCertificate(this.getSigningKeyAlias()).getPublicKey() : publicKey;
            RSASSAVerifier verifier = new RSASSAVerifier(key);
            rc = token.verify((JWSVerifier)verifier);
        }
        catch (KeyStoreException | KeystoreServiceException e) {
            throw new TokenServiceException("Cannot verify token.", (Exception)e);
        }
        return rc;
    }

    public boolean verifyToken(JWT token, String jwksurl, String algorithm) throws TokenServiceException {
        boolean verified = false;
        try {
            if (algorithm != null && jwksurl != null) {
                JWSAlgorithm expectedJWSAlg = JWSAlgorithm.parse((String)algorithm);
                RemoteJWKSet keySource = new RemoteJWKSet(new URL(jwksurl));
                JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(expectedJWSAlg, (JWKSource)keySource);
                DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
                jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
                DefaultJWTClaimsVerifier claimsVerifier = new DefaultJWTClaimsVerifier();
                jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)claimsVerifier);
                SecurityContext ctx = null;
                jwtProcessor.process(token.toString(), ctx);
                verified = true;
            }
        }
        catch (JOSEException | BadJOSEException | MalformedURLException | ParseException e) {
            throw new TokenServiceException("Cannot verify token.", (Exception)e);
        }
        return verified;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        if (this.aliasService == null || this.keystoreService == null) {
            throw new ServiceLifecycleException("Alias or Keystore service is not set");
        }
        this.config = config;
    }

    public void start() throws ServiceLifecycleException {
        KeyStore keystore;
        try {
            keystore = this.keystoreService.getSigningKeystore();
            if (keystore == null) {
                throw new ServiceLifecycleException(RESOURCES.signingKeystoreNotAvailable(this.config.getSigningKeystorePath()));
            }
        }
        catch (KeystoreServiceException e) {
            throw new ServiceLifecycleException(RESOURCES.signingKeystoreNotAvailable(this.config.getSigningKeystorePath()), (Exception)((Object)e));
        }
        try {
            this.cachedSigningKeyPassphrase = this.aliasService.getSigningKeyPassphrase();
            if (this.cachedSigningKeyPassphrase == null) {
                throw new ServiceLifecycleException(RESOURCES.signingKeyPassphraseNotAvailable(this.config.getSigningKeyPassphraseAlias()));
            }
        }
        catch (AliasServiceException e) {
            throw new ServiceLifecycleException(RESOURCES.signingKeyPassphraseNotAvailable(this.config.getSigningKeyPassphraseAlias()), (Exception)((Object)e));
        }
        String signingKeyAlias = this.getSigningKeyAlias();
        try {
            Certificate certificate = keystore.getCertificate(signingKeyAlias);
            if (certificate == null) {
                throw new ServiceLifecycleException(RESOURCES.publicSigningKeyNotFound(signingKeyAlias));
            }
            PublicKey publicKey = certificate.getPublicKey();
            if (publicKey == null) {
                throw new ServiceLifecycleException(RESOURCES.publicSigningKeyNotFound(signingKeyAlias));
            }
            if (!(publicKey instanceof RSAPublicKey)) {
                throw new ServiceLifecycleException(RESOURCES.publicSigningKeyWrongType(signingKeyAlias));
            }
        }
        catch (KeyStoreException e) {
            throw new ServiceLifecycleException(RESOURCES.publicSigningKeyNotFound(signingKeyAlias), (Exception)e);
        }
        try {
            Key key = keystore.getKey(signingKeyAlias, this.cachedSigningKeyPassphrase);
            if (key == null) {
                throw new ServiceLifecycleException(RESOURCES.privateSigningKeyNotFound(signingKeyAlias));
            }
            if (!(key instanceof RSAPrivateKey)) {
                throw new ServiceLifecycleException(RESOURCES.privateSigningKeyWrongType(signingKeyAlias));
            }
            this.signingKey = (RSAPrivateKey)key;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new ServiceLifecycleException(RESOURCES.privateSigningKeyNotFound(signingKeyAlias), (Exception)e);
        }
    }

    public void stop() throws ServiceLifecycleException {
    }

    static {
        SUPPORTED_SIG_ALGS.add("RS256");
        SUPPORTED_SIG_ALGS.add("RS384");
        SUPPORTED_SIG_ALGS.add("RS512");
        SUPPORTED_SIG_ALGS.add("PS256");
        SUPPORTED_SIG_ALGS.add("PS384");
        SUPPORTED_SIG_ALGS.add("PS512");
    }
}

