/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.j2e.util;

import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.CommonHelper;

public class FilterHelper {
    private final ServletContext servletContext;

    public FilterHelper(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void addFilterMapping(String name, Filter filter, Object ... parameters) {
        CommonHelper.assertNotBlank((String)"name", (String)name);
        CommonHelper.assertNotNull((String)"filter", (Object)filter);
        CommonHelper.assertNotNull((String)"parameters", (Object)parameters);
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<DispatcherType> types = new ArrayList<DispatcherType>();
        for (Object parameter : parameters) {
            if (parameter instanceof String) {
                urls.add((String)parameter);
                continue;
            }
            if (parameter instanceof DispatcherType) {
                types.add((DispatcherType)parameter);
                continue;
            }
            throw new TechnicalException("Unsupported parameter type: " + parameter);
        }
        if (urls.isEmpty()) {
            throw new TechnicalException("No URL mapping defined for filter: " + name);
        }
        if (types.isEmpty()) {
            types.add(DispatcherType.REQUEST);
        }
        FilterRegistration.Dynamic registration = this.servletContext.addFilter(name, filter);
        registration.addMappingForUrlPatterns(EnumSet.copyOf(types), true, urls.toArray(new String[urls.size()]));
    }
}

