/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cm.descriptor;

import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.ClouderaManagerIntegrationMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfigChangeListener;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorImpl;

public class ClouderaManagerDescriptorParser
implements AdvancedServiceDiscoveryConfigChangeListener {
    private static final ClouderaManagerIntegrationMessages log = (ClouderaManagerIntegrationMessages)MessagesFactory.get(ClouderaManagerIntegrationMessages.class);
    private static final String CONFIG_NAME_DISCOVERY_TYPE = "discoveryType";
    private static final String CONFIG_NAME_DISCOVERY_ADDRESS = "discoveryAddress";
    private static final String CONFIG_NAME_DISCOVERY_USER = "discoveryUser";
    private static final String CONFIG_NAME_DISCOVERY_PASSWORD_ALIAS = "discoveryPasswordAlias";
    private static final String CONFIG_NAME_DISCOVERY_CLUSTER = "cluster";
    private static final String CONFIG_NAME_PROVIDER_CONFIG_REFERENCE = "providerConfigRef";
    private static final String CONFIG_NAME_APPLICATION_PREFIX = "app";
    private static final String CONFIG_NAME_SERVICE_URL = "url";
    private static final String CONFIG_NAME_SERVICE_VERSION = "version";
    private Map<String, AdvancedServiceDiscoveryConfig> advancedServiceDiscoveryConfigMap = new ConcurrentHashMap<String, AdvancedServiceDiscoveryConfig>();

    public Set<SimpleDescriptor> parse(String path) {
        return this.parse(path, null);
    }

    public Set<SimpleDescriptor> parse(String path, String topologyName) {
        try {
            log.parseClouderaManagerDescriptor(path, topologyName == null ? "all topologies" : topologyName);
            Configuration xmlConfiguration = new Configuration(false);
            xmlConfiguration.addResource(Paths.get(path, new String[0]).toUri().toURL());
            xmlConfiguration.reloadConfiguration();
            Set<SimpleDescriptor> descriptors = this.parseXmlConfig(xmlConfiguration, topologyName);
            log.parsedClouderaManagerDescriptor(String.join((CharSequence)", ", descriptors.stream().map(descriptor -> descriptor.getName()).collect(Collectors.toSet())), path);
            return descriptors;
        }
        catch (Exception e) {
            log.failedToParseXmlConfiguration(path, e.getMessage(), e);
            return Collections.emptySet();
        }
    }

    private Set<SimpleDescriptor> parseXmlConfig(Configuration xmlConfiguration, String topologyName) {
        LinkedHashSet<SimpleDescriptor> descriptors = new LinkedHashSet<SimpleDescriptor>();
        xmlConfiguration.forEach(xmlDescriptor -> {
            SimpleDescriptor descriptor;
            String descriptorName = (String)xmlDescriptor.getKey();
            if ((topologyName == null || descriptorName.equals(topologyName)) && (descriptor = this.parseXmlDescriptor(descriptorName, (String)xmlDescriptor.getValue())) != null) {
                descriptors.add(descriptor);
            }
        });
        return descriptors;
    }

    private SimpleDescriptor parseXmlDescriptor(String name, String xmlValue) {
        try {
            String[] configurationPairs;
            SimpleDescriptorImpl descriptor = new SimpleDescriptorImpl();
            descriptor.setReadOnly(true);
            descriptor.setName(name);
            block18: for (String configurationPair : configurationPairs = xmlValue.split(";")) {
                String parameterName;
                String[] parameterPairParts = configurationPair.trim().split("=", 2);
                switch (parameterName = parameterPairParts[0].trim()) {
                    case "discoveryType": {
                        descriptor.setDiscoveryType(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "discoveryAddress": {
                        descriptor.setDiscoveryAddress(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "discoveryUser": {
                        descriptor.setDiscoveryUser(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "discoveryPasswordAlias": {
                        descriptor.setDiscoveryPasswordAlias(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "cluster": {
                        descriptor.setCluster(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "providerConfigRef": {
                        descriptor.setProviderConfig(parameterPairParts[1].trim());
                        continue block18;
                    }
                    default: {
                        if (parameterName.startsWith(CONFIG_NAME_APPLICATION_PREFIX)) {
                            this.parseApplication(descriptor, configurationPair.trim());
                            continue block18;
                        }
                        this.parseService(descriptor, configurationPair.trim());
                    }
                }
            }
            AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig = this.advancedServiceDiscoveryConfigMap.get(name);
            if (advancedServiceDiscoveryConfig != null) {
                this.setDiscoveryDetails(descriptor, advancedServiceDiscoveryConfig);
                this.addEnabledServices(descriptor, advancedServiceDiscoveryConfig);
            }
            return descriptor;
        }
        catch (Exception e) {
            log.failedToParseDescriptor(name, e.getMessage(), e);
            return null;
        }
    }

    private void setDiscoveryDetails(SimpleDescriptorImpl descriptor, AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig) {
        if (StringUtils.isBlank((CharSequence)descriptor.getDiscoveryAddress())) {
            descriptor.setDiscoveryAddress(advancedServiceDiscoveryConfig.getDiscoveryAddress());
        }
        if (StringUtils.isBlank((CharSequence)descriptor.getCluster())) {
            descriptor.setCluster(advancedServiceDiscoveryConfig.getDiscoveryCluster());
        }
        if (StringUtils.isBlank((CharSequence)descriptor.getDiscoveryType())) {
            descriptor.setDiscoveryType("ClouderaManager");
        }
    }

    private void addEnabledServices(SimpleDescriptorImpl descriptor, AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig) {
        advancedServiceDiscoveryConfig.getEnabledServiceNames().forEach(enabledServiceName -> {
            if (descriptor.getService(enabledServiceName) == null) {
                SimpleDescriptorImpl.ServiceImpl service = new SimpleDescriptorImpl.ServiceImpl();
                service.setName(enabledServiceName);
                descriptor.addService((SimpleDescriptor.Service)service);
            }
        });
    }

    private void parseApplication(SimpleDescriptorImpl descriptor, String configurationPair) {
        String[] applicationParts = configurationPair.split(":");
        String applicationName = applicationParts[1].trim();
        SimpleDescriptorImpl.ApplicationImpl application = (SimpleDescriptorImpl.ApplicationImpl)descriptor.getApplication(applicationName);
        if (application == null) {
            application = new SimpleDescriptorImpl.ApplicationImpl();
            descriptor.addApplication((SimpleDescriptor.Application)application);
            application.setName(applicationParts[1]);
        }
        if (applicationParts.length > 2) {
            String applicationParameters = configurationPair.substring(applicationName.length() + 5);
            String[] applicationParameterParts = applicationParameters.split("=", 2);
            application.addParam(applicationParameterParts[0], applicationParameterParts[1]);
        }
    }

    private void parseService(SimpleDescriptorImpl descriptor, String configurationPair) {
        String[] serviceParts = configurationPair.split(":");
        String serviceName = serviceParts[0].trim();
        if (this.isServiceEnabled(descriptor.getName(), serviceName)) {
            SimpleDescriptorImpl.ServiceImpl service = (SimpleDescriptorImpl.ServiceImpl)descriptor.getService(serviceName);
            if (service == null) {
                service = new SimpleDescriptorImpl.ServiceImpl();
                service.setName(serviceName);
                descriptor.addService((SimpleDescriptor.Service)service);
            }
            if (serviceParts.length > 1) {
                String serviceConfiguration = configurationPair.substring(serviceName.length() + 1).trim();
                String[] serviceConfigurationParts = serviceConfiguration.split("=", 2);
                String serviceConfigurationName = serviceConfigurationParts[0].trim();
                String serviceConfigurationValue = serviceConfigurationParts[1].trim();
                switch (serviceConfigurationName) {
                    case "url": {
                        service.addUrl(serviceConfigurationValue);
                        break;
                    }
                    case "version": {
                        service.setVersion(serviceConfigurationValue);
                        break;
                    }
                    default: {
                        service.addParam(serviceConfigurationName, serviceConfigurationValue);
                    }
                }
            }
        } else {
            log.serviceDisabled(serviceName, descriptor.getName());
        }
    }

    private boolean isServiceEnabled(String descriptorName, String serviceName) {
        return this.advancedServiceDiscoveryConfigMap.containsKey(descriptorName) ? this.advancedServiceDiscoveryConfigMap.get(descriptorName).isServiceEnabled(serviceName) : true;
    }

    @Override
    public void onAdvancedServiceDiscoveryConfigurationChange(Properties newConfiguration) {
        AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig = new AdvancedServiceDiscoveryConfig(newConfiguration);
        String topologyName = advancedServiceDiscoveryConfig.getTopologyName();
        if (StringUtils.isBlank((CharSequence)topologyName)) {
            throw new IllegalArgumentException("Invalid advanced service discovery configuration: topology name is missing!");
        }
        this.advancedServiceDiscoveryConfigMap.put(topologyName, advancedServiceDiscoveryConfig);
        log.updatedAdvanceServiceDiscoverytConfiguration(topologyName);
    }
}

