/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.RequestDecorator;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.Control;

public final class AbandonRequestDecorator
extends RequestDecorator<AbandonRequest>
implements AbandonRequest {
    public AbandonRequestDecorator(LdapApiService codec, AbandonRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public int getAbandoned() {
        return ((AbandonRequest)this.getDecorated()).getAbandoned();
    }

    public AbandonRequest setAbandoned(int requestId) {
        ((AbandonRequest)this.getDecorated()).setAbandoned(requestId);
        return this;
    }

    public AbandonRequest setMessageId(int messageId) {
        super.setMessageId(messageId);
        return this;
    }

    public AbandonRequest addControl(Control control) {
        return (AbandonRequest)super.addControl(control);
    }

    public AbandonRequest addAllControls(Control[] controls) {
        return (AbandonRequest)super.addAllControls(controls);
    }

    public AbandonRequest removeControl(Control control) {
        return (AbandonRequest)super.removeControl(control);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)80);
            buffer.put((byte)BerValue.getNbBytes((int)this.getAbandoned()));
            buffer.put(BerValue.getBytes((int)this.getAbandoned()));
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err((I18n)I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, (Object[])new Object[0]);
            throw new EncoderException(msg, (Exception)boe);
        }
        return buffer;
    }

    public int computeLength() {
        return 2 + BerValue.getNbBytes((int)this.getAbandoned());
    }
}

