/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import org.apache.shiro.util.Factory;

public abstract class AbstractFactory<T>
implements Factory<T> {
    private boolean singleton = true;
    private T singletonInstance;

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public T getInstance() {
        T instance;
        if (this.isSingleton()) {
            if (this.singletonInstance == null) {
                this.singletonInstance = this.createInstance();
            }
            instance = this.singletonInstance;
        } else {
            instance = this.createInstance();
        }
        if (instance == null) {
            String msg = "Factory 'createInstance' implementation returned a null object.";
            throw new IllegalStateException(msg);
        }
        return instance;
    }

    protected abstract T createInstance();
}

