/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

class NiFiResponseUtil {
    NiFiResponseUtil() {
    }

    static void modifyOutboundResponse(HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        if (inboundResponse.getStatusLine().getStatusCode() == 302) {
            Header originalLocationHeader = inboundResponse.getFirstHeader("Location");
            if (originalLocationHeader != null) {
                URIBuilder originalLocationUriBuilder;
                String originalLocation = originalLocationHeader.getValue();
                try {
                    originalLocationUriBuilder = new URIBuilder(originalLocation);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Unable to parse URI from Location header", e);
                }
                URIBuilder inboundRequestUriBuilder = null;
                try {
                    inboundRequestUriBuilder = new URIBuilder(inboundRequest.getRequestURI());
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("Unable to parse the inbound request URI", e);
                }
                String inboundRequestUriPath = inboundRequestUriBuilder.getPath();
                String originalLocationUriPath = originalLocationUriBuilder.getPath();
                if (originalLocationUriPath.contains(inboundRequestUriPath)) {
                    String trailingSlash = originalLocationUriPath.endsWith("/") ? "/" : "";
                    List queryParams = originalLocationUriBuilder.getQueryParams();
                    String scheme = inboundRequest.getHeader("X-Forwarded-Proto");
                    String host = inboundRequest.getHeader("X-Forwarded-Server");
                    String port = inboundRequest.getHeader("X-Forwarded-Port");
                    String baseContextPath = inboundRequest.getHeader("X-Forwarded-Context");
                    String pathInfo = inboundRequest.getPathInfo();
                    try {
                        URI newLocation = new URIBuilder().setScheme(scheme).setHost(host).setPort(StringUtils.isNumeric((String)port) ? Integer.parseInt(port) : -1).setPath(baseContextPath + pathInfo + trailingSlash).setParameters(queryParams).build();
                        outboundResponse.setHeader("Location", newLocation.toString());
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException("Unable to rewrite Location header in response", e);
                    }
                }
            } else {
                throw new RuntimeException("Received HTTP 302, but response is missing Location header");
            }
        }
    }
}

