/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AuthorizationResponse
implements Response {
    private final URI redirectURI;
    private final State state;
    private final ResponseMode rm;

    protected AuthorizationResponse(URI redirectURI, State state, ResponseMode rm) {
        if (redirectURI == null) {
            throw new IllegalArgumentException("The redirection URI must not be null");
        }
        this.redirectURI = redirectURI;
        this.state = state;
        this.rm = rm;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public State getState() {
        return this.state;
    }

    public ResponseMode getResponseMode() {
        return this.rm;
    }

    public abstract ResponseMode impliedResponseMode();

    public abstract Map<String, String> toParameters();

    public URI toURI() {
        ResponseMode rm = this.impliedResponseMode();
        StringBuilder sb = new StringBuilder(this.getRedirectionURI().toString());
        if (rm.equals(ResponseMode.QUERY)) {
            if (StringUtils.isBlank((CharSequence)this.getRedirectionURI().getRawQuery())) {
                sb.append('?');
            } else {
                sb.append('&');
            }
        } else if (rm.equals(ResponseMode.FRAGMENT)) {
            sb.append('#');
        } else {
            throw new SerializeException("The (implied) response mode must be query or fragment");
        }
        sb.append(URLUtils.serializeParameters(this.toParameters()));
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new SerializeException("Couldn't serialize response: " + e.getMessage(), e);
        }
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        if (ResponseMode.FORM_POST.equals(this.rm)) {
            throw new SerializeException("The response mode must not be form_post");
        }
        HTTPResponse response = new HTTPResponse(302);
        response.setLocation(this.toURI());
        return response;
    }

    public HTTPRequest toHTTPRequest() {
        HTTPRequest request;
        if (!ResponseMode.FORM_POST.equals(this.rm)) {
            throw new SerializeException("The response mode must be form_post");
        }
        try {
            request = new HTTPRequest(HTTPRequest.Method.POST, this.redirectURI.toURL());
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        request.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        request.setQuery(URLUtils.serializeParameters(this.toParameters()));
        return request;
    }

    public AuthorizationSuccessResponse toSuccessResponse() {
        return (AuthorizationSuccessResponse)this;
    }

    public AuthorizationErrorResponse toErrorResponse() {
        return (AuthorizationErrorResponse)this;
    }

    public static AuthorizationResponse parse(URI redirectURI, Map<String, String> params) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)params.get("error"))) {
            return AuthorizationErrorResponse.parse(redirectURI, params);
        }
        return AuthorizationSuccessResponse.parse(redirectURI, params);
    }

    public static AuthorizationResponse parse(URI uri) throws ParseException {
        Map<String, String> params;
        if (uri.getRawFragment() != null) {
            params = URLUtils.parseParameters(uri.getRawFragment());
        } else if (uri.getRawQuery() != null) {
            params = URLUtils.parseParameters(uri.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthorizationResponse.parse(URIUtils.getBaseURI(uri), params);
    }

    public static AuthorizationResponse parse(HTTPResponse httpResponse) throws ParseException {
        URI location = httpResponse.getLocation();
        if (location == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthorizationResponse.parse(location);
    }

    public static AuthorizationResponse parse(HTTPRequest httpRequest) throws ParseException {
        URI baseURI;
        try {
            baseURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (httpRequest.getQuery() != null) {
            return AuthorizationResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getQuery()));
        }
        if (httpRequest.getFragment() != null) {
            return AuthorizationResponse.parse(baseURI, URLUtils.parseParameters(httpRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }
}

