/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.karaf.log.command.DisplayLog;
import org.apache.karaf.log.core.LogService;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

@Command(scope="log", name="tail", description="Continuously display log entries. Use ctrl-c to quit this command")
@Service
public class LogTail
extends DisplayLog {
    @Reference
    Session session;
    @Reference
    LogService logService;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public Object execute() throws Exception {
        PrintEventThread printThread = new PrintEventThread();
        ReadKeyBoardThread readKeyboardThread = new ReadKeyBoardThread(Thread.currentThread());
        this.executorService.execute(printThread);
        this.executorService.execute(readKeyboardThread);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        printThread.abort();
        readKeyboardThread.abort();
        this.executorService.shutdownNow();
        return null;
    }

    class PrintEventThread
    implements Runnable {
        PrintStream out = System.out;
        boolean doDisplay = true;

        PrintEventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int minLevel = Integer.MAX_VALUE;
            if (LogTail.this.level != null) {
                switch (LogTail.this.level.toLowerCase()) {
                    case "debug": {
                        minLevel = 7;
                        break;
                    }
                    case "info": {
                        minLevel = 6;
                        break;
                    }
                    case "warn": {
                        minLevel = 4;
                        break;
                    }
                    case "error": {
                        minLevel = 3;
                    }
                }
            }
            Iterable<PaxLoggingEvent> le = LogTail.this.logService.getEvents(LogTail.this.entries == 0 ? Integer.MAX_VALUE : LogTail.this.entries);
            for (PaxLoggingEvent event : le) {
                LogTail.this.printEvent(this.out, event, minLevel);
            }
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            PaxAppender appender = new PaxAppender(){

                public void doAppend(PaxLoggingEvent event) {
                    queue.add(event);
                }
            };
            try {
                LogTail.this.logService.addAppender(appender);
                while (this.doDisplay) {
                    int sl;
                    PaxLoggingEvent event = (PaxLoggingEvent)queue.take();
                    if (event == null || (sl = event.getLevel().getSyslogEquivalent()) > minLevel) continue;
                    LogTail.this.printEvent(this.out, event);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                LogTail.this.logService.removeAppender(appender);
            }
            this.out.println();
        }

        public void abort() {
            this.doDisplay = false;
        }
    }

    class ReadKeyBoardThread
    implements Runnable {
        private Thread sessionThread;
        boolean readKeyboard = true;

        public ReadKeyBoardThread(Thread thread) {
            this.sessionThread = thread;
        }

        public void abort() {
            this.readKeyboard = false;
        }

        @Override
        public void run() {
            while (this.readKeyboard) {
                try {
                    int c = LogTail.this.session.getKeyboard().read();
                    if (c >= 0) continue;
                    this.sessionThread.interrupt();
                }
                catch (IOException e) {}
                break;
            }
        }
    }
}

